/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.ServerUtils;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;

public class ParamScan
extends FreqParam {
    @Override
    public void printHelp(aa listener) {
        listener.a("Usage: freq scan [playername].");
        listener.a("Reports the frequencies [playername] can broadcast on and owns.");
        listener.a((new String[]{"Eg. freq scan codechicken", "Eg. freq scan"})[rand.nextInt(2)]);
    }

    @Override
    public String getName() {
        return "scan";
    }

    @Override
    public void handleCommand(String playername, String[] subArray, aa listener) {
        RedstoneEther ether = RedstoneEther.get(false);
        if (subArray.length == 1 && ServerUtils.getPlayer((String)playername) == null) {
            listener.a("Invalid number of parameters.");
            return;
        }
        String scanPlayer = subArray.length == 1 ? playername : subArray[1];
        StringBuilder returnstring = new StringBuilder().append(scanPlayer);
        int ranges = 0;
        int endfreq = ether.getLastPublicFrequency();
        do {
            int[] freqrange = ether.getNextFrequencyRange(scanPlayer, endfreq + 1, false);
            int startfreq = freqrange[0];
            endfreq = freqrange[1];
            if (startfreq == -1) break;
            if (ranges == 0) {
                returnstring.append(" can broadcast on: ");
            } else {
                returnstring.append(", ");
            }
            if (startfreq == endfreq) {
                returnstring.append(startfreq);
            } else {
                returnstring.append(startfreq).append("-").append(endfreq);
            }
            ++ranges;
        } while (endfreq != 5000);
        if (ranges == 0) {
            listener.a(returnstring.append(" can only broadcast on public frequencies.").toString());
        } else {
            listener.a(returnstring.append(".").toString());
        }
    }
}

