/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ClientUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.wirelessredstone.addons.ClientMapInfo;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.GuiWirelessSniffer;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.core.FreqChunkPosition;
import codechicken.wirelessredstone.core.FreqCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.client.Minecraft;

public class WRAddonClientPacketHandler
implements PacketCustom.ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, ayh nethandler, Minecraft mc) {
        this.handlePacket(mc.e, (qx)mc.g, packet);
    }

    private void handlePacket(ayp world, qx player, PacketCustom packet) {
        switch (packet.getType()) {
            case 53: {
                WRAddonClientPacketHandler.processSnifferFreqUpdate(packet);
                break;
            }
            case 54: {
                WRAddonClientPacketHandler.processSnifferEtherCopy(packet);
                break;
            }
            case 55: {
                RedstoneEtherAddons.client().setTriangAngle(packet.readUnsignedShort(), packet.readFloat());
                break;
            }
            case 56: {
                WRAddonClientPacketHandler.processMapInfo((yc)world, player, packet);
                break;
            }
            case 57: {
                WRAddonClientPacketHandler.processMapUpdate((yc)world, player, packet);
                break;
            }
            case 59: {
                if (packet.readBoolean()) {
                    this.throwREP(packet.readInt(), packet.readInt(), world, player);
                    break;
                }
                world.b(packet.readInt());
                break;
            }
            case 60: {
                this.processTrackerUpdate(packet, world, player);
                break;
            }
            case 61: {
                if (packet.readBoolean()) {
                    this.throwTracker(packet.readInt(), packet.readInt(), world, player);
                    break;
                }
                world.b(packet.readInt());
            }
        }
    }

    private void throwTracker(int entityID, int throwerID, ayp world, qx player) {
        lq thrower = world.a(throwerID);
        if (throwerID == player.k) {
            thrower = player;
        }
        if (thrower != null && thrower instanceof md) {
            EntityWirelessTracker tracker = new EntityWirelessTracker((yc)world, 0, (md)thrower);
            tracker.k = entityID;
            world.a(entityID, (lq)tracker);
            world.a(thrower, "random.bow", 0.5f, 0.4f / (world.t.nextFloat() * 0.4f + 0.8f));
        }
    }

    private void processTrackerUpdate(PacketCustom packet, ayp world, qx player) {
        int entityID = packet.readInt();
        boolean attached = packet.readBoolean();
        lq e = world.a(entityID);
        if (e != null && e.L) {
            e = null;
        }
        if (!(e instanceof EntityWirelessTracker)) {
            if (e != null) {
                FMLCommonHandler.instance().raiseException((Throwable)new IllegalStateException(), "EntityID mapped to non tracker", false);
                return;
            }
            e = new EntityWirelessTracker((yc)world);
            e.k = entityID;
            world.a(entityID, e);
        }
        EntityWirelessTracker tracker = (EntityWirelessTracker)e;
        if (attached) {
            int attachedEntityID = packet.readInt();
            Object attachedEntity = attachedEntityID == player.k ? player : world.a(attachedEntityID);
            if (attachedEntity == null) {
                return;
            }
            tracker.attached = true;
            tracker.attachedEntity = attachedEntity;
            tracker.attachedX = packet.readFloat();
            tracker.attachedY = packet.readFloat();
            tracker.attachedZ = packet.readFloat();
            tracker.attachedYaw = packet.readFloat();
        } else {
            tracker.attachedEntity = null;
            tracker.attached = false;
            tracker.t = packet.readFloat();
            tracker.u = packet.readFloat();
            tracker.v = packet.readFloat();
            tracker.w = packet.readFloat();
            tracker.x = packet.readFloat();
            tracker.y = packet.readFloat();
            tracker.b(tracker.t, tracker.u, tracker.v);
            tracker.h(tracker.w, tracker.x, tracker.y);
            tracker.attachmentCounter = packet.readUnsignedShort();
            tracker.item = packet.readBoolean();
        }
    }

    private void throwREP(int entityID, int throwerID, ayp world, qx player) {
        lq thrower = world.a(throwerID);
        if (throwerID == player.k) {
            thrower = player;
        }
        if (thrower != null && thrower instanceof md) {
            EntityREP rep = new EntityREP((yc)world, (md)thrower);
            rep.k = entityID;
            world.a(entityID, (lq)rep);
        }
    }

    private static void processSnifferFreqUpdate(PacketCustom packet) {
        aul currentscreen = ClientUtils.mc().r;
        if (currentscreen == null || !(currentscreen instanceof GuiWirelessSniffer)) {
            return;
        }
        GuiWirelessSniffer sniffergui = (GuiWirelessSniffer)currentscreen;
        sniffergui.setEtherFreq(packet.readUnsignedShort(), packet.readBoolean());
    }

    private static void processSnifferEtherCopy(PacketCustom packet) {
        aul currentscreen = ClientUtils.mc().r;
        if (currentscreen == null || !(currentscreen instanceof GuiWirelessSniffer)) {
            return;
        }
        GuiWirelessSniffer sniffergui = (GuiWirelessSniffer)currentscreen;
        sniffergui.setEtherCopy(packet.readByteArray(packet.readUnsignedShort()));
    }

    private static void processMapUpdate(yc world, qx player, PacketCustom packet) {
        WirelessMapNodeStorage mapstorage = RedstoneEtherAddons.client().getMapNodes();
        int numaddednodes = packet.readUnsignedShort();
        int i = 0;
        while (i < numaddednodes) {
            FreqChunkPosition node = new FreqChunkPosition((int)packet.readShort(), -1, (int)packet.readShort(), packet.readUnsignedShort());
            mapstorage.nodes.add(node);
            ++i;
        }
        int numremovednodes = packet.readUnsignedShort();
        int i2 = 0;
        while (i2 < numremovednodes) {
            FreqChunkPosition node = new FreqChunkPosition((int)packet.readShort(), -1, (int)packet.readShort(), packet.readUnsignedShort());
            mapstorage.nodes.remove(node);
            ++i2;
        }
        int numremotes = packet.readUnsignedShort();
        mapstorage.devices.clear();
        int i3 = 0;
        while (i3 < numremotes) {
            mapstorage.devices.add(new FreqCoord((double)packet.readFloat(), -1.0, (double)packet.readFloat(), packet.readUnsignedShort()));
            ++i3;
        }
    }

    private static void processMapInfo(yc world, qx player, PacketCustom packet) {
        short mapno = packet.readShort();
        int xCenter = packet.readInt();
        int zCenter = packet.readInt();
        byte scale = packet.readByte();
        RedstoneEtherAddons.client().setMPMapInfo(mapno, new ClientMapInfo(xCenter, zCenter, scale));
    }

    public static void sendOpenSniffer() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 50);
        packet.writeBoolean(true);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendCloseSniffer() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 50);
        packet.writeBoolean(false);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendSetRemote(boolean active) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 51);
        packet.writeBoolean(active);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendSyncTriang(int freq, boolean required) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 52);
        packet.writeShort(freq);
        packet.writeBoolean(required);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendResetMap() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 58);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }
}

