/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.colour.Colour;
import codechicken.core.colour.ColourARGB;
import codechicken.wirelessredstone.core.RedstoneEther;
import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class RemoteTexManager {
    private static int[] texGrad = new int[256];
    private static int[] texOff = new int[256];
    private static int[] texOn = new int[256];
    private static byte[] imageData = new byte[1024];

    static {
        RemoteTexManager.init();
    }

    private static void init() {
        try {
            BufferedImage bufferedimage = ImageIO.read(Minecraft.class.getResource("/codechicken/wirelessredstone/addons/addons1.png"));
            bufferedimage.getRGB(16, 0, 16, 16, texGrad, 0, 16);
            bufferedimage.getRGB(32, 0, 16, 16, texOff, 0, 16);
            bufferedimage.getRGB(48, 0, 16, 16, texOn, 0, 16);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Wireless Redstone", true);
        }
    }

    public static int getIconIndex(int colourid, boolean on) {
        return 128 + colourid + 1 + (on ? 16 : 0);
    }

    public static void generateTextures() {
        GL11.glBindTexture((int)3553, (int)Minecraft.x().o.b("/codechicken/wirelessredstone/addons/addons1.png"));
        int i = 0;
        while (i < 14) {
            RemoteTexManager.processTexture(RedstoneEther.colours[i], false, RemoteTexManager.getIconIndex(i, false));
            RemoteTexManager.processTexture(RedstoneEther.colours[i], true, RemoteTexManager.getIconIndex(i, true));
            ++i;
        }
        RemoteTexManager.processTexture(-1, false, RemoteTexManager.getIconIndex(-1, false));
        RemoteTexManager.processTexture(-1, true, RemoteTexManager.getIconIndex(-1, true));
    }

    private static void processTexture(int colour, boolean on, int iconindex) {
        RemoteTexManager.mergeTexturesWithColour(new ColourARGB(colour), on);
        ByteBuffer imagebuffer = arx.c((int)1024);
        imagebuffer.put(imageData);
        imagebuffer.position(0).limit(1024);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)(16 * (iconindex % 16)), (int)(16 * (iconindex / 16)), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)imagebuffer);
    }

    private static void mergeTexturesWithColour(ColourARGB texcolour, boolean on) {
        int i = 0;
        while (i < 256) {
            Object colour = (texGrad[i] & 0xFF000000) == 0 ? new ColourARGB(on ? texOn[i] : texOff[i]) : new ColourARGB(texGrad[i]).multiply((Colour)texcolour);
            RemoteTexManager.imageData[i * 4 + 0] = colour.r;
            RemoteTexManager.imageData[i * 4 + 1] = colour.g;
            RemoteTexManager.imageData[i * 4 + 2] = colour.b;
            RemoteTexManager.imageData[i * 4 + 3] = colour.a;
            ++i;
        }
    }
}

