/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ue;

import java.util.EnumSet;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyConsumer;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IVoltage;

public class TileEntityUniversalElectricityConsumer
extends TileEntityEnergyConsumer
implements IVoltage {
    private int _wattsLastTick;

    public TileEntityUniversalElectricityConsumer() {
        this(0);
    }

    public TileEntityUniversalElectricityConsumer(int voltageIndex) {
        super(PowerConverterCore.powerSystemUniversalElectricity, voltageIndex, IConductor.class);
        ElectricityConnections.registerConnector((any)this, EnumSet.range(ForgeDirection.DOWN, ForgeDirection.EAST));
    }

    @Override
    public void g() {
        super.g();
        double watts = 0.0;
        boolean foundInput = false;
        for (Map.Entry conductor : this.getTiles().entrySet()) {
            ElectricityNetwork inputNetwork = ElectricityNetwork.getNetworkFromTileEntity((any)((any)conductor.getValue()), (ForgeDirection)((ForgeDirection)conductor.getKey()));
            if (inputNetwork == null) continue;
            if (foundInput || this.getTotalEnergyDemand() <= 0) {
                inputNetwork.stopRequesting((any)this);
                continue;
            }
            int desiredWatts = this.getTotalEnergyDemand() / PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerInput();
            inputNetwork.startRequesting((any)this, (double)desiredWatts / this.getVoltage(new Object[0]), this.getVoltage(new Object[0]));
            ElectricityPack pack = inputNetwork.consumeElectricity((any)this);
            if (UniversalElectricity.isVoltageSensitive && pack.voltage > this.getVoltage(new Object[0])) {
                this.k.a(null, (double)this.l, (double)this.m, (double)this.n, 2.0f, true);
            }
            watts += pack.getWatts();
            foundInput = true;
        }
        this.storeEnergy(ke.c((double)(watts * (double)PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerInput())));
        this._wattsLastTick = (int)watts;
    }

    public double getVoltage(Object ... data) {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    @Override
    public int getInputRate() {
        return this._wattsLastTick;
    }
}

