/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.railcraft;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyConsumer;

public class TileEntityRailCraftConsumer
extends TileEntityEnergyConsumer
implements ITankContainer {
    private LiquidTank _steamTank = new LiquidTank(1000);
    private int _mBLastTick;

    public TileEntityRailCraftConsumer() {
        super(PowerConverterCore.powerSystemSteam, 0, ITankContainer.class);
    }

    @Override
    public void g() {
        super.g();
        if (this._steamTank != null && this._steamTank.getLiquid() != null) {
            int amount = this._steamTank.getLiquid().amount;
            int energy = amount * PowerConverterCore.powerSystemSteam.getInternalEnergyPerInput();
            energy = this.storeEnergy(energy);
            int toDrain = amount - energy / PowerConverterCore.powerSystemSteam.getInternalEnergyPerInput();
            this._steamTank.drain(toDrain, true);
            this._mBLastTick = toDrain;
        } else {
            this._mBLastTick = 0;
        }
    }

    @Override
    public int getVoltageIndex() {
        return 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != PowerConverterCore.steamId) {
            return 0;
        }
        return this._steamTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != PowerConverterCore.steamId) {
            return 0;
        }
        return this._steamTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._steamTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (type != null && type.itemID == PowerConverterCore.steamId) {
            return this._steamTank;
        }
        return null;
    }

    @Override
    public int getInputRate() {
        return this._mBLastTick;
    }
}

