/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ic2;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityIndustrialCraftProducer
extends TileEntityEnergyProducer
implements IEnergySource {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;

    public TileEntityIndustrialCraftProducer() {
        this(0);
    }

    public TileEntityIndustrialCraftProducer(int voltageIndex) {
        super(PowerConverterCore.powerSystemIndustrialCraft, voltageIndex, IEnergyAcceptor.class);
    }

    @Override
    public void g() {
        super.g();
        if (!this._didFirstAddToNet && !this.k.I) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
    }

    public void s() {
        super.s();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void w_() {
        if (this._isAddedToEnergyNet) {
            if (!this.k.I) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.w_();
    }

    @Override
    public int produceEnergy(int energy) {
        if (!this._isAddedToEnergyNet) {
            return energy;
        }
        int eu = energy / PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerOutput();
        if (eu < this.getMaxEnergyOutput()) {
            return energy;
        }
        int producedEu = Math.min(eu, this.getMaxEnergyOutput());
        EnergyTileSourceEvent e = new EnergyTileSourceEvent((IEnergySource)this, producedEu);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return (eu - (producedEu - e.amount)) * PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerOutput();
    }

    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return true;
    }

    public boolean isAddedToEnergyNet() {
        return this._isAddedToEnergyNet;
    }

    public int getMaxEnergyOutput() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }
}

