/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.gui;

import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.ContainerEnergyBridge;

public class GuiEnergyBridge
extends avf {
    private static final int _barColor = -16734721;
    protected TileEntityEnergyBridge _bridge;

    public GuiEnergyBridge(ContainerEnergyBridge container, TileEntityEnergyBridge te) {
        super((rq)container);
        this.c = 195;
        this._bridge = te;
    }

    protected void b(int mouseX, int mouseY) {
        this.l.b("Energy Bridge", 8, 6, 0x404040);
        if (this._bridge.isInputLimited()) {
            this.l.b("INPUT LIMITED", 98, 6, -1);
        } else {
            this.l.b("OUTPUT LIMITED", 90, 6, -1);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            this.l.b(dir.toString(), 10, 6 + 12 * (i + 1), -1);
            BridgeSideData data = this._bridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                String name = data.powerSystem.getAbbreviation();
                if (data.powerSystem.getVoltageNames() != null) {
                    name = name + " " + data.powerSystem.getVoltageNames()[data.voltageNameIndex];
                }
                this.l.b(name, 49, 6 + 12 * (i + 1), -1);
                this.l.b(data.isConsumer ? "IN" : "OUT", 92, 6 + 12 * (i + 1), -1);
                this.l.b(this.getOutputRateString(data), 119, 6 + 12 * (i + 1), -1);
                continue;
            }
            this.l.b("<NONE>", 49, 6 + 12 * (i + 1), -1);
        }
        this.l.b("% CHG", 10, 90, -1);
        GL11.glDisable((int)2896);
        GuiEnergyBridge.a((int)46, (int)97, (int)(46 + this._bridge.getEnergyScaled()), (int)89, (int)-16734721);
        GL11.glEnable((int)2896);
        this.l.b(bm.a((String)"container.inventory"), 8, this.c - 96 + 2, 0x404040);
    }

    protected void a(float gameTicks, int mouseX, int mouseY) {
        int texture = this.f.o.b("/powercrystals/powerconverters/textures/gui/energybridge.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f.o.b(texture);
        int x = (this.g - this.b) / 2;
        int y = (this.h - this.c) / 2;
        this.b(x, y, 0, 0, this.b, this.c);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            BridgeSideData data = this._bridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                if (!data.isConnected) {
                    this.b(x + 7, y + 15 + 12 * i, 0, 208, 162, 12);
                    continue;
                }
                if (data.outputRate == 0) {
                    this.b(x + 7, y + 15 + 12 * i, 0, 234, 162, 12);
                    continue;
                }
                this.b(x + 7, y + 15 + 12 * i, 0, 195, 162, 12);
                continue;
            }
            this.b(x + 7, y + 15 + 12 * i, 0, 221, 162, 12);
        }
    }

    private String getOutputRateString(BridgeSideData data) {
        if (!data.isConnected) {
            return "NO LINK";
        }
        int rate = data.outputRate;
        if (rate > 1000) {
            double rateThousand = (double)rate / 1000.0;
            return String.format("%.1f %s%s", rateThousand, "k", data.powerSystem.getUnit());
        }
        return rate + " " + data.powerSystem.getUnit();
    }
}

