/*
 * Decompiled with CFR 0.152.
 */
package xeno.reliquary.items;

import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;
import java.util.List;
import xeno.reliquary.Reliquary;
import xeno.reliquary.items.ItemXR;

public class ItemVoidSatchel
extends ItemXR {
    public ItemVoidSatchel(int par1) {
        super(par1);
        this.c(108);
        this.e(0);
        this.d(1);
        this.canRepair = false;
        this.a(Reliquary.tabsXR);
        this.b("voidSatchel");
        this.setTextureFile("/xr/art/xritems.png");
    }

    @SideOnly(value=Side.CLIENT)
    public vb f(ur stack) {
        return vb.d;
    }

    public void a(ur ist, qx par2EntityPlayer, List par3List, boolean par4) {
        bq tag = ist.p();
        String details0 = "This Void Satchel currently ";
        String details1 = "holds ";
        String capacity = "It has a capacity of ";
        if (tag == null || new ur((int)tag.d("itemID"), 1, (int)tag.d("itemMeta")).b() == null) {
            details1 = details1 + "nothing.";
            capacity = capacity + 64;
        } else {
            ur contents = new ur((int)tag.d("itemID"), 1, (int)tag.d("itemMeta"));
            String itemName = contents.r();
            details1 = details1 + tag.d("itemQuantity") + "x " + itemName;
            capacity = capacity + tag.d("capacity");
        }
        par3List.add(details0);
        par3List.add(details1);
        par3List.add(capacity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean e(ur stack) {
        return this.getIsTurnedOn(stack);
    }

    private boolean getIsTurnedOn(ur stack) {
        return this.getBoolean("isTurnedOn", stack);
    }

    public void a(ur ist, yc world, lq e, int i, boolean f) {
        if (world.I) {
            return;
        }
        if (!this.getIsTurnedOn(ist)) {
            return;
        }
        qx player = null;
        if (e instanceof qx) {
            player = (qx)e;
        }
        if (player == null) {
            return;
        }
        qw inventory = player.bJ;
        this.compressInventoryForPlayer(ist, (la)inventory);
    }

    public ur a(ur ist, yc world, qx player) {
        this.setBoolean("isTurnedOn", ist, !this.getIsTurnedOn(ist));
        return ist;
    }

    public boolean a(ur ist, qx player, yc world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (side == 1) {
            this.setBoolean("isTurnedOn", ist, false);
            int quantity = this.getShort("itemQuantity", ist) >= 64 ? (player.ah() ? this.getShort("itemQuantity", ist) : 64) : this.getShort("itemQuantity", ist);
            int depletedBy = 0;
            while (quantity > 0) {
                ur contents = new ur(this.getShort("itemID", ist), 1, this.getShort("itemMeta", ist));
                if (quantity > contents.d()) {
                    contents.a = contents.d();
                    quantity -= contents.d();
                    depletedBy += contents.d();
                } else {
                    contents.a = quantity;
                    depletedBy += quantity;
                    quantity = 0;
                }
                if (world.I) continue;
                px item = new px(world, (double)((float)x + 0.5f), (double)((float)y + 1.5f), (double)((float)z + 0.5f), contents);
                world.d((lq)item);
            }
            this.setShort("itemQuantity", ist, this.getShort("itemQuantity", ist) - depletedBy);
        }
        return true;
    }

    public boolean onItemUseFirst(ur ist, qx player, yc world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.q(x, y, z) instanceof la) {
            la inventory = (la)world.q(x, y, z);
            if (player.ah()) {
                this.compressInventoryForBlock(ist, inventory);
            } else {
                this.unloadContentsIntoInventory(ist, inventory, player);
            }
            return false;
        }
        return false;
    }

    public void unloadContentsIntoInventory(ur ist, la inventory, qx player) {
        int quantity;
        bq satchelTag = ist.p();
        if (satchelTag == null) {
            return;
        }
        ur contents = new ur((int)satchelTag.d("itemID"), 1, (int)satchelTag.d("itemMeta"));
        for (quantity = satchelTag.d("itemQuantity"); quantity > 0 && this.tryToAddToInventory(contents, inventory); --quantity) {
        }
        player.p.a((lq)player, "random.orb", 0.1f, 0.5f * ((player.p.t.nextFloat() - player.p.t.nextFloat()) * 0.7f + 1.8f));
        satchelTag.a("itemQuantity", (short)quantity);
        ist.d(satchelTag);
    }

    public boolean tryToAddToInventory(ur contents, la inventory) {
        int slot;
        for (slot = 0; slot < inventory.k_(); ++slot) {
            if (inventory.a(slot) == null || !inventory.a(slot).a(contents) || inventory.a((int)slot).a == inventory.a(slot).d()) continue;
            ++inventory.a((int)slot).a;
            return true;
        }
        for (slot = 0; slot < inventory.k_(); ++slot) {
            if (inventory.a(slot) != null) continue;
            inventory.a(slot, new ur(contents.c, contents.a, contents.j()));
            return true;
        }
        return false;
    }

    public void compressInventoryForPlayer(ur ist, la inventory) {
        ur target = this.getTargetItem(ist);
        if (target == null) {
            return;
        }
        if (this.isSatchelFull(ist)) {
            return;
        }
        if (this.findAndRemove(inventory, target)) {
            this.increaseSatchelQuantity(ist);
        }
    }

    public void compressInventoryForBlock(ur ist, la inventory) {
        ur target = this.getTargetItem(ist);
        if (target == null) {
            return;
        }
        while (!this.isSatchelFull(ist) && this.findAndRemove(inventory, target)) {
            this.increaseSatchelQuantity(ist);
        }
    }

    private boolean hasItem(ur ist) {
        return this.getShort("itemQuantity", ist) > 0;
    }

    private boolean isSatchelFull(ur ist) {
        return this.getShort("itemQuantity", ist) >= this.getShort("capacity", ist);
    }

    public void decreaseSatchelQuantity(ur ist) {
        this.setShort("itemQuantity", ist, this.getShort("itemQuantity", ist) - 1);
    }

    public void increaseSatchelQuantity(ur ist) {
        this.setShort("itemQuantity", ist, this.getShort("itemQuantity", ist) + 1);
    }

    public boolean findAndRemove(la inventory, ur ist) {
        for (int slot = 0; slot < inventory.k_(); ++slot) {
            ur stack = inventory.a(slot);
            if (stack == null || !inventory.a(slot).a(ist)) continue;
            inventory.a(slot, 1);
            return true;
        }
        return false;
    }

    public ur getTargetItem(ur ist) {
        return new ur(this.getShort("itemID", ist), 1, this.getShort("itemMeta", ist));
    }
}

