/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;

public class AabbUtil {
    public static Direction getIntersection(aoj origin, aoj direction, aoe bbox, aoj intersection) {
        double length = direction.b();
        aoj normalizedDirection = aoj.a((double)(direction.c / length), (double)(direction.d / length), (double)(direction.e / length));
        Direction intersectingDirection = AabbUtil.intersects(origin, normalizedDirection, bbox);
        if (intersectingDirection == null) {
            return null;
        }
        aoj planeOrigin = normalizedDirection.c < 0.0 && normalizedDirection.d < 0.0 && normalizedDirection.e < 0.0 ? aoj.a((double)bbox.d, (double)bbox.e, (double)bbox.f) : (normalizedDirection.c < 0.0 && normalizedDirection.d < 0.0 && normalizedDirection.e >= 0.0 ? aoj.a((double)bbox.d, (double)bbox.e, (double)bbox.c) : (normalizedDirection.c < 0.0 && normalizedDirection.d >= 0.0 && normalizedDirection.e < 0.0 ? aoj.a((double)bbox.d, (double)bbox.b, (double)bbox.f) : (normalizedDirection.c < 0.0 && normalizedDirection.d >= 0.0 && normalizedDirection.e >= 0.0 ? aoj.a((double)bbox.d, (double)bbox.b, (double)bbox.c) : (normalizedDirection.c >= 0.0 && normalizedDirection.d < 0.0 && normalizedDirection.e < 0.0 ? aoj.a((double)bbox.a, (double)bbox.e, (double)bbox.f) : (normalizedDirection.c >= 0.0 && normalizedDirection.d < 0.0 && normalizedDirection.e >= 0.0 ? aoj.a((double)bbox.a, (double)bbox.e, (double)bbox.c) : (normalizedDirection.c >= 0.0 && normalizedDirection.d >= 0.0 && normalizedDirection.e < 0.0 ? aoj.a((double)bbox.a, (double)bbox.b, (double)bbox.f) : aoj.a((double)bbox.a, (double)bbox.b, (double)bbox.c)))))));
        aoj planeNormalVector = null;
        switch (intersectingDirection) {
            case XN: 
            case XP: {
                planeNormalVector = aoj.a((double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case YN: 
            case YP: {
                planeNormalVector = aoj.a((double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case ZN: 
            case ZP: {
                planeNormalVector = aoj.a((double)0.0, (double)0.0, (double)1.0);
            }
        }
        aoj newIntersection = AabbUtil.getIntersectionWithPlane(origin, normalizedDirection, planeOrigin, planeNormalVector);
        intersection.c = newIntersection.c;
        intersection.d = newIntersection.d;
        intersection.e = newIntersection.e;
        return intersectingDirection;
    }

    public static Direction intersects(aoj origin, aoj direction, aoe bbox) {
        double[] ray = AabbUtil.getRay(origin, direction);
        if (direction.c < 0.0 && direction.d < 0.0 && direction.e < 0.0) {
            if (origin.c < bbox.a) {
                return null;
            }
            if (origin.d < bbox.b) {
                return null;
            }
            if (origin.e < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return Direction.ZP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return Direction.YP;
            }
            return Direction.XP;
        }
        if (direction.c < 0.0 && direction.d < 0.0 && direction.e >= 0.0) {
            if (origin.c < bbox.a) {
                return null;
            }
            if (origin.d < bbox.b) {
                return null;
            }
            if (origin.e > bbox.f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return Direction.XP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
                return Direction.YP;
            }
            return Direction.ZN;
        }
        if (direction.c < 0.0 && direction.d >= 0.0 && direction.e < 0.0) {
            if (origin.c < bbox.a) {
                return null;
            }
            if (origin.d > bbox.e) {
                return null;
            }
            if (origin.e < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return Direction.ZP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
                return Direction.XP;
            }
            return Direction.YN;
        }
        if (direction.c < 0.0 && direction.d >= 0.0 && direction.e >= 0.0) {
            if (origin.c < bbox.a) {
                return null;
            }
            if (origin.d > bbox.e) {
                return null;
            }
            if (origin.e > bbox.f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return Direction.YN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return Direction.ZN;
            }
            return Direction.XP;
        }
        if (direction.c >= 0.0 && direction.d < 0.0 && direction.e < 0.0) {
            if (origin.c > bbox.d) {
                return null;
            }
            if (origin.d < bbox.b) {
                return null;
            }
            if (origin.e < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return Direction.XN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return Direction.ZP;
            }
            return Direction.YP;
        }
        if (direction.c >= 0.0 && direction.d < 0.0 && direction.e >= 0.0) {
            if (origin.c > bbox.d) {
                return null;
            }
            if (origin.d < bbox.b) {
                return null;
            }
            if (origin.e > bbox.f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return Direction.ZN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return Direction.XN;
            }
            return Direction.YP;
        }
        if (direction.c >= 0.0 && direction.d >= 0.0 && direction.e < 0.0) {
            if (origin.c > bbox.d) {
                return null;
            }
            if (origin.d > bbox.e) {
                return null;
            }
            if (origin.e < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return Direction.XN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return Direction.YN;
            }
            return Direction.ZP;
        }
        if (origin.c > bbox.d) {
            return null;
        }
        if (origin.d > bbox.e) {
            return null;
        }
        if (origin.e > bbox.f) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
            return Direction.XN;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
            return Direction.ZN;
        }
        return Direction.YN;
    }

    private static double[] getRay(aoj origin, aoj direction) {
        double[] ret = new double[]{origin.c * direction.d - direction.c * origin.d, origin.c * direction.e - direction.c * origin.e, -direction.c, origin.d * direction.e - direction.d * origin.e, -direction.e, direction.d};
        return ret;
    }

    private static double[] getEdgeRay(Edge edge, aoe bbox) {
        switch (edge) {
            case AD: {
                return new double[]{-bbox.b, -bbox.c, -1.0, 0.0, 0.0, 0.0};
            }
            case AB: {
                return new double[]{bbox.a, 0.0, 0.0, -bbox.c, 0.0, 1.0};
            }
            case AE: {
                return new double[]{0.0, bbox.a, 0.0, bbox.b, -1.0, 0.0};
            }
            case DC: {
                return new double[]{bbox.d, 0.0, 0.0, -bbox.c, 0.0, 1.0};
            }
            case DH: {
                return new double[]{0.0, bbox.d, 0.0, bbox.b, -1.0, 0.0};
            }
            case BC: {
                return new double[]{-bbox.e, -bbox.c, -1.0, 0.0, 0.0, 0.0};
            }
            case BF: {
                return new double[]{0.0, bbox.a, 0.0, bbox.e, -1.0, 0.0};
            }
            case EH: {
                return new double[]{-bbox.b, -bbox.f, -1.0, 0.0, 0.0, 0.0};
            }
            case EF: {
                return new double[]{bbox.a, 0.0, 0.0, -bbox.f, 0.0, 1.0};
            }
            case CG: {
                return new double[]{0.0, bbox.d, 0.0, bbox.e, -1.0, 0.0};
            }
            case FG: {
                return new double[]{-bbox.e, -bbox.f, -1.0, 0.0, 0.0, 0.0};
            }
            case HG: {
                return new double[]{bbox.d, 0.0, 0.0, -bbox.f, 0.0, 1.0};
            }
        }
        return new double[0];
    }

    private static double side(double[] ray1, double[] ray2) {
        return ray1[2] * ray2[3] + ray1[5] * ray2[1] + ray1[4] * ray2[0] + ray1[1] * ray2[5] + ray1[0] * ray2[4] + ray1[3] * ray2[2];
    }

    private static aoj getIntersectionWithPlane(aoj origin, aoj direction, aoj planeOrigin, aoj planeNormalVector) {
        double distance = AabbUtil.getDistanceToPlane(origin, direction, planeOrigin, planeNormalVector);
        return aoj.a((double)(origin.c + direction.c * distance), (double)(origin.d + direction.d * distance), (double)(origin.e + direction.e * distance));
    }

    private static double getDistanceToPlane(aoj origin, aoj direction, aoj planeOrigin, aoj planeNormalVector) {
        aoj base = aoj.a((double)(planeOrigin.c - origin.c), (double)(planeOrigin.d - origin.d), (double)(planeOrigin.e - origin.e));
        return AabbUtil.dotProduct(base, planeNormalVector) / AabbUtil.dotProduct(direction, planeNormalVector);
    }

    private static double dotProduct(aoj a, aoj b) {
        return a.c * b.c + a.d * b.d + a.e * b.e;
    }

    static enum Edge {
        AD,
        AB,
        AE,
        DC,
        DH,
        BC,
        BF,
        EH,
        EF,
        CG,
        FG,
        HG;

    }
}

