/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.core.IC2;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.DimensionManager;

public class DataEncoder {
    public static Object decode(DataInputStream is) throws IOException {
        byte type = is.readByte();
        switch (type) {
            case 0: {
                return is.readInt();
            }
            case 1: {
                int length = is.readShort();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readInt();
                }
                return data;
            }
            case 2: {
                return is.readShort();
            }
            case 3: {
                int length = is.readShort();
                short[] data = new short[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readShort();
                }
                return data;
            }
            case 4: {
                return is.readByte();
            }
            case 5: {
                int length = is.readShort();
                byte[] data = new byte[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readByte();
                }
                return data;
            }
            case 6: {
                return is.readLong();
            }
            case 7: {
                int length = is.readShort();
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readLong();
                }
                return data;
            }
            case 8: {
                return is.readBoolean();
            }
            case 9: {
                int length = is.readShort();
                boolean[] data = new boolean[length];
                byte b = 0;
                for (int i = 0; i < length; ++i) {
                    if (i % 8 == 0) {
                        b = is.readByte();
                    }
                    data[i] = (b & 1 << i % 8) != 0;
                }
                return data;
            }
            case 10: {
                int length = is.readShort();
                char[] data = new char[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readChar();
                }
                return new String(data);
            }
            case 11: {
                int length = is.readShort();
                String[] data = new String[length];
                for (int i = 0; i < length; ++i) {
                    int slength = is.readShort();
                    char[] sdata = new char[slength];
                    for (int j = 0; j < slength; ++j) {
                        sdata[j] = is.readChar();
                    }
                    data[i] = new String(sdata);
                }
                return data;
            }
            case 12: {
                short id = is.readShort();
                if (id == 0) {
                    return null;
                }
                byte stackSize = is.readByte();
                short meta = is.readShort();
                ur stack = new ur((int)id, (int)stackSize, (int)meta);
                if (up.e[id].n()) {
                    stack.d(ca.a((DataInput)is));
                }
                return stack;
            }
            case 13: {
                return cd.b((DataInput)is);
            }
            case 14: {
                byte kind = is.readByte();
                int id = is.readInt();
                switch (kind) {
                    case 0: {
                        return amq.p[id];
                    }
                    case 1: {
                        return up.e[id];
                    }
                    case 2: {
                        return jh.e.get(id);
                    }
                    case 3: {
                        return ll.a[id];
                    }
                    case 4: {
                        return xc.b[id];
                    }
                }
            }
            case 15: {
                byte kind = is.readByte();
                int x = is.readInt();
                int y = 0;
                if (kind == 1 || kind == 2) {
                    y = is.readInt();
                }
                int z = is.readInt();
                switch (kind) {
                    case 0: {
                        return new xv(x, z);
                    }
                    case 1: {
                        return new s(x, y, z);
                    }
                    case 2: {
                        return new yv(x, y, z);
                    }
                }
            }
            case 16: {
                int dimension = is.readInt();
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                return DimensionManager.getWorld((int)dimension).q(x, y, z);
            }
            case 17: {
                int dimension = is.readInt();
                return DimensionManager.getWorld((int)dimension);
            }
            case 18: {
                return Float.valueOf(is.readFloat());
            }
            case 19: {
                int length = is.readShort();
                float[] data = new float[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readFloat();
                }
                return data;
            }
            case 20: {
                return is.readDouble();
            }
            case 21: {
                int length = is.readShort();
                double[] data = new double[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readDouble();
                }
                return data;
            }
            case 127: {
                return null;
            }
        }
        IC2.platform.displayError("An unknown data type was received over multiplayer to be decoded.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: type ID " + type + ")");
        return null;
    }

    public static void encode(DataOutputStream os, Object o) throws IOException {
        if (o instanceof Integer) {
            os.writeByte(0);
            os.writeInt((Integer)o);
        } else if (o instanceof int[]) {
            os.writeByte(1);
            int[] oa = (int[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeInt(oa[i]);
            }
        } else if (o instanceof Short) {
            os.writeByte(2);
            os.writeShort(((Short)o).shortValue());
        } else if (o instanceof short[]) {
            os.writeByte(3);
            short[] oa = (short[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeShort(oa[i]);
            }
        } else if (o instanceof Byte) {
            os.writeByte(4);
            os.writeByte(((Byte)o).byteValue());
        } else if (o instanceof byte[]) {
            os.writeByte(5);
            byte[] oa = (byte[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeByte(oa[i]);
            }
        } else if (o instanceof Long) {
            os.writeByte(6);
            os.writeLong((Long)o);
        } else if (o instanceof long[]) {
            os.writeByte(7);
            long[] oa = (long[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeLong(oa[i]);
            }
        } else if (o instanceof Boolean) {
            os.writeByte(8);
            os.writeBoolean((Boolean)o);
        } else if (o instanceof boolean[]) {
            os.writeByte(9);
            boolean[] oa = (boolean[])o;
            os.writeShort(oa.length);
            int b = 0;
            for (int i = 0; i < oa.length; ++i) {
                if (i % 8 == 0 && i > 0) {
                    os.writeByte(b);
                    b = 0;
                }
                b = (byte)(b | (oa[i] ? 1 : 0) << i % 8);
            }
            os.writeByte(b);
        } else if (o instanceof String) {
            os.writeByte(10);
            String oa = (String)o;
            os.writeShort(oa.length());
            os.writeChars(oa);
        } else if (o instanceof String[]) {
            os.writeByte(11);
            String[] oa = (String[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeShort(oa[i].length());
                os.writeChars(oa[i]);
            }
        } else if (o instanceof ur) {
            bq compound;
            os.writeByte(12);
            ur oa = (ur)o;
            os.writeShort(oa.c);
            if (oa.c == 0) {
                return;
            }
            os.writeByte(oa.a);
            os.writeShort(oa.j());
            if (up.e[oa.c].n() && (compound = oa.p()) != null) {
                ca.a((bq)compound, (DataOutput)os);
            }
        } else if (o instanceof cd) {
            os.writeByte(13);
            cd.a((cd)((cd)o), (DataOutput)os);
        } else if (o instanceof amq) {
            os.writeByte(14);
            os.writeByte(0);
            os.writeInt(((amq)o).cm);
        } else if (o instanceof up) {
            os.writeByte(14);
            os.writeByte(1);
            os.writeInt(((up)o).cj);
        } else if (o instanceof jg) {
            os.writeByte(14);
            os.writeByte(2);
            os.writeInt(((jg)o).e);
        } else if (o instanceof ll) {
            os.writeByte(14);
            os.writeByte(3);
            os.writeInt(((ll)o).H);
        } else if (o instanceof xc) {
            os.writeByte(14);
            os.writeByte(4);
            os.writeInt(((xc)o).z);
        } else if (o instanceof s) {
            os.writeByte(15);
            os.writeByte(0);
            s oa = (s)o;
            os.writeInt(oa.a);
            os.writeInt(oa.b);
            os.writeInt(oa.c);
        } else if (o instanceof xv) {
            os.writeByte(15);
            os.writeByte(1);
            xv oa = (xv)o;
            os.writeInt(oa.a);
            os.writeInt(oa.b() - 8 >> 4);
        } else if (o instanceof yv) {
            os.writeByte(15);
            os.writeByte(1);
            yv oa = (yv)o;
            os.writeInt(oa.a);
            os.writeInt(oa.b);
            os.writeInt(oa.c);
        } else if (o instanceof any) {
            os.writeByte(16);
            any oa = (any)o;
            os.writeInt(oa.k.u.h);
            os.writeInt(oa.l);
            os.writeInt(oa.m);
            os.writeInt(oa.n);
        } else if (o instanceof yc) {
            os.writeByte(17);
            os.writeInt(((yc)o).u.h);
        } else if (o instanceof Float) {
            os.writeByte(18);
            os.writeFloat(((Float)o).floatValue());
        } else if (o instanceof float[]) {
            os.writeByte(19);
            float[] oa = (float[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeFloat(oa[i]);
            }
        } else if (o instanceof Double) {
            os.writeByte(20);
            os.writeDouble((Double)o);
        } else if (o instanceof double[]) {
            os.writeByte(21);
            double[] oa = (double[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeDouble(oa[i]);
            }
        } else if (o == null) {
            os.writeByte(127);
        } else {
            IC2.platform.displayError("An unknown data type was attempted to be encoded for sending through\nmultiplayer.\nThis could happen due to a bug.\n\n(Technical information: " + o.getClass().getName() + ")");
        }
    }
}

