/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.IReactor;
import ic2.api.IReactorComponent;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.item.ItemGradual;
import java.util.ArrayList;

public class ItemReactorUranium
extends ItemGradual
implements IReactorComponent {
    public int numberOfCells;

    public ItemReactorUranium(int id, int index, int cells) {
        super(id, index);
        this.numberOfCells = cells;
    }

    @Override
    public void processChamber(IReactor reactor, ur yourStack, int x, int y) {
        if (!reactor.produceEnergy()) {
            return;
        }
        for (int iteration = 0; iteration < this.numberOfCells; ++iteration) {
            int heat;
            int dheat;
            int pulses = 1 + this.numberOfCells / 2;
            for (int i = 0; i < pulses; ++i) {
                this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y);
            }
            ArrayList heatAcceptors = new ArrayList();
            this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            for (heat = this.sumUp(pulses += this.checkPulseable(reactor, x - 1, y, yourStack, x, y) + this.checkPulseable(reactor, x + 1, y, yourStack, x, y) + this.checkPulseable(reactor, x, y - 1, yourStack, x, y) + this.checkPulseable(reactor, x, y + 1, yourStack, x, y)) * 4; heatAcceptors.size() > 0 && heat > 0; heat += dheat) {
                dheat = heat / heatAcceptors.size();
                heat -= dheat;
                dheat = ((IReactorComponent)((ItemStackCoord)heatAcceptors.get((int)0)).stack.b()).alterHeat(reactor, ((ItemStackCoord)heatAcceptors.get((int)0)).stack, ((ItemStackCoord)heatAcceptors.get((int)0)).x, ((ItemStackCoord)heatAcceptors.get((int)0)).y, dheat);
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (yourStack.j() >= this.m() - 1) {
            if (IC2.random.nextInt(3) == 0) {
                reactor.setItemAt(x, y, new ur(Ic2Items.nearDepletedUraniumCell.b(), this.numberOfCells));
            } else {
                reactor.setItemAt(x, y, null);
            }
        } else {
            yourStack.a(1, null);
        }
    }

    private int checkPulseable(IReactor reactor, int x, int y, ur me, int mex, int mey) {
        ur other = reactor.getItemAt(x, y);
        if (other != null && other.b() instanceof IReactorComponent && ((IReactorComponent)other.b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey)) {
            return 1;
        }
        return 0;
    }

    private int sumUp(int x) {
        int sum = 0;
        for (int i = 1; i <= x; ++i) {
            sum += i;
        }
        return sum;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList heatAcceptors) {
        ur thing = reactor.getItemAt(x, y);
        if (thing != null && thing.b() instanceof IReactorComponent && ((IReactorComponent)thing.b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ur yourStack, ur pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        reactor.addOutput(1);
        return true;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ur yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ur yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ur yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ur yourStack, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ur yourStack) {
        return 2 * this.numberOfCells;
    }

    private class ItemStackCoord {
        public ur stack;
        public int x;
        public int y;

        public ItemStackCoord(ur stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

