/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockContainerCommon;
import ic2.core.block.BlockPoleFence;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.item.ElectricItem;
import ic2.core.util.AabbUtil;
import java.util.List;
import java.util.Random;

public class BlockLuminator
extends BlockContainerCommon {
    boolean light;

    public BlockLuminator(int id, boolean l) {
        super(id, l ? 30 : 31, agi.r);
        this.a(j);
        this.light = l;
        this.c(0.3f);
        this.b(0.5f);
        if (!this.light) {
            this.a(IC2.tabIC2);
        }
    }

    public int a(Random random) {
        return 0;
    }

    public boolean b_(yc world, int i, int j, int k, int direction) {
        if (world.a(i, j, k) != 0) {
            return false;
        }
        switch (direction) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public static boolean isSupportingBlock(yc world, int i, int j, int k) {
        if (world.a(i, j, k) == 0) {
            return false;
        }
        if (world.s(i, j, k)) {
            return true;
        }
        return BlockLuminator.isSpecialSupporter((ym)world, i, j, k);
    }

    public static boolean isSpecialSupporter(ym world, int i, int j, int k) {
        amq block = amq.p[world.a(i, j, k)];
        if (block == null) {
            return false;
        }
        if (block instanceof ake || block instanceof BlockPoleFence || block instanceof BlockCable) {
            return true;
        }
        return block.cm == Ic2Items.reinforcedGlass.c || block == amq.P;
    }

    public boolean d(yc world, int i, int j, int k) {
        any te = world.q(i, j, k);
        if (te != null && ((TileEntityLuminator)te).ignoreBlockStay) {
            return true;
        }
        int facing = world.h(i, j, k);
        switch (facing) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public void a(yc world, int i, int j, int k, int l) {
        if (!this.d(world, i, j, k)) {
            world.e(i, j, k, 0);
        }
        super.a(world, i, j, k, l);
    }

    public boolean b() {
        return false;
    }

    public int d() {
        return IC2.platform.getRenderId("luminator");
    }

    public aoe getCollisionBoundingBoxFromPool(yc world, int x, int y, int z, int meta) {
        return this.e(world, x, y, z);
    }

    public aoe e(yc world, int x, int y, int z) {
        float[] box = BlockLuminator.getBoxOfLuminator((ym)world, x, y, z);
        return aoe.a().a((double)(box[0] + (float)x), (double)(box[1] + (float)y), (double)(box[2] + (float)z), (double)(box[3] + (float)x), (double)(box[4] + (float)y), (double)(box[5] + (float)z));
    }

    public aoe b_(yc world, int x, int y, int z) {
        return this.e(world, x, y, z);
    }

    public aoh a(yc world, int x, int y, int z, aoj origin, aoj absDirection) {
        aoj direction = aoj.a((double)(absDirection.c - origin.c), (double)(absDirection.d - origin.d), (double)(absDirection.e - origin.e));
        double maxLength = direction.b();
        aoj intersection = aoj.a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, this.e(world, x, y, z), intersection);
        if (intersectingDirection != null && intersection.d(origin) <= maxLength) {
            return new aoh(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public static float[] getBoxOfLuminator(ym world, int x, int y, int z) {
        int facing = world.h(x, y, z);
        float px2 = 0.0625f;
        switch (facing) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        boolean fullCover = BlockLuminator.isSpecialSupporter(world, x, y, z);
        switch (facing) {
            case 1: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f * px2, 1.0f};
            }
            case 2: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 15.0f * px2, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{6.0f * px2, 3.0f * px2, 14.0f * px2, 1.0f - 6.0f * px2, 1.0f - 3.0f * px2, 1.0f};
            }
            case 3: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f * px2};
                }
                return new float[]{6.0f * px2, 3.0f * px2, 0.0f, 1.0f - 6.0f * px2, 1.0f - 3.0f * px2, 2.0f * px2};
            }
            case 4: {
                if (fullCover) {
                    return new float[]{15.0f * px2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{14.0f * px2, 3.0f * px2, 6.0f * px2, 1.0f, 1.0f - 3.0f * px2, 1.0f - 6.0f * px2};
            }
            case 5: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f * px2, 1.0f, 1.0f};
                }
                return new float[]{0.0f, 3.0f * px2, 6.0f * px2, 2.0f * px2, 1.0f - 3.0f * px2, 1.0f - 6.0f * px2};
            }
        }
        if (fullCover) {
            return new float[]{0.0f, 15.0f * px2, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{4.0f * px2, 13.0f * px2, 4.0f * px2, 1.0f - 4.0f * px2, 1.0f, 1.0f - 4.0f * px2};
    }

    public boolean c() {
        return false;
    }

    public boolean isBlockNormalCube(yc world, int i, int j, int k) {
        return false;
    }

    public boolean a(yc world, int i, int j, int k, qx entityplayer, int side, float a, float b, float c) {
        ur itemStack = entityplayer.bS();
        if (itemStack == null || !(itemStack.b() instanceof IElectricItem)) {
            return false;
        }
        itemStack.b();
        TileEntityLuminator lumi = (TileEntityLuminator)world.q(i, j, k);
        int transfer = lumi.getMaxEnergy() - lumi.energy;
        if (transfer <= 0) {
            return false;
        }
        transfer = ElectricItem.discharge(itemStack, transfer, 2, true, false);
        if (!this.light) {
            world.c(i, j, k, Ic2Items.activeLuminator.c, world.h(i, j, k));
            lumi = (TileEntityLuminator)world.q(i, j, k);
        }
        lumi.energy += transfer;
        return true;
    }

    public void a(yc world, int i, int j, int k, lq entity) {
        if (this.light && entity instanceof qj) {
            entity.c(entity instanceof md && ((md)entity).bC() == mf.b ? 20 : 10);
        }
    }

    @Override
    public any createTileEntity(yc world, int meta) {
        return new TileEntityLuminator();
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_0.png";
    }

    public void a(int i, tj tabs, List itemList) {
        if (!this.light) {
            super.a(i, tabs, itemList);
        }
    }
}

