/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.machine.ContainerPump;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class TileEntityPump
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int soundTicker = IC2.random.nextInt(64);
    public short pumpCharge = 0;
    private AudioSource audioSource;

    public TileEntityPump() {
        super(2, 1, 200, 32);
    }

    @Override
    public String b() {
        return "Pump";
    }

    @Override
    public void g() {
        super.g();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && !this.isPumpReady()) {
            --this.energy;
            this.pumpCharge = (short)(this.pumpCharge + 1);
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (this.isPumpReady()) {
            needsInvUpdate = this.pump();
        }
        if (this.getActive() == this.isPumpReady() && this.energy > 0) {
            this.setActive(!this.getActive());
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean pump() {
        if (!this.canHarvest()) {
            return false;
        }
        if (this.isWaterBelow() || this.isLavaBelow()) {
            int id = this.k.a(this.l, this.m - 1, this.n);
            this.k.e(this.l, this.m - 1, this.n, 0);
            if (id == amq.D.cm) {
                id = amq.E.cm;
            }
            if (id == amq.F.cm) {
                id = amq.G.cm;
            }
            return this.pumpThis(id);
        }
        if (this.inventory[0] != null && this.inventory[0].c == up.aw.cj) {
            ur customBucket = new ur(up.aw);
            MinecraftForge.EVENT_BUS.post((Event)new FillBucketEvent(null, customBucket, this.k, new aoh(this.l, this.m - 1, this.n, 1, this.k.S().a((double)this.l, (double)(this.m - 1), (double)this.n))));
            if (customBucket != null && customBucket.c != up.aw.cj) {
                ArrayList<ur> drops = new ArrayList<ur>();
                drops.add(customBucket);
                StackUtil.distributeDrop(this, drops);
                --this.inventory[0].a;
                if (this.inventory[0].a <= 0) {
                    this.inventory[0] = null;
                }
                this.pumpCharge = 0;
                return true;
            }
        }
        return false;
    }

    public boolean isWaterBelow() {
        return (this.k.a(this.l, this.m - 1, this.n) == amq.D.cm || this.k.a(this.l, this.m - 1, this.n) == amq.E.cm) && this.k.h(this.l, this.m - 1, this.n) == 0;
    }

    public boolean isLavaBelow() {
        return (this.k.a(this.l, this.m - 1, this.n) == amq.F.cm || this.k.a(this.l, this.m - 1, this.n) == amq.G.cm) && this.k.h(this.l, this.m - 1, this.n) == 0;
    }

    public boolean pumpThis(int id) {
        if (id == amq.G.cm && this.deliverLavaToGeo()) {
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].c == up.aw.cj) {
            if (id == amq.E.cm) {
                this.inventory[0].c = up.ax.cj;
            }
            if (id == amq.G.cm) {
                this.inventory[0].c = up.ay.cj;
            }
            ArrayList<ur> drops = new ArrayList<ur>();
            drops.add(this.inventory[0]);
            StackUtil.distributeDrop(this, drops);
            this.inventory[0] = null;
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].c == Ic2Items.cell.c) {
            ur drop = null;
            if (id == amq.E.cm) {
                drop = Ic2Items.waterCell.l();
            }
            if (id == amq.G.cm) {
                drop = Ic2Items.lavaCell.l();
            }
            --this.inventory[0].a;
            if (this.inventory[0].a <= 0) {
                this.inventory[0] = null;
            }
            ArrayList<ur> drops = new ArrayList<ur>();
            drops.add(drop);
            StackUtil.distributeDrop(this, drops);
            this.pumpCharge = 0;
            return true;
        }
        this.pumpCharge = 0;
        return this.putInChestBucket(id);
    }

    public boolean putInChestBucket(int id) {
        return this.putInChestBucket(this.l, this.m + 1, this.n, id) || this.putInChestBucket(this.l, this.m - 1, this.n, id) || this.putInChestBucket(this.l + 1, this.m, this.n, id) || this.putInChestBucket(this.l - 1, this.m, this.n, id) || this.putInChestBucket(this.l, this.m, this.n + 1, id) || this.putInChestBucket(this.l, this.m, this.n - 1, id);
    }

    public boolean putInChestBucket(int x, int y, int z, int id) {
        if (!(this.k.q(x, y, z) instanceof anm)) {
            return false;
        }
        anm chest = (anm)this.k.q(x, y, z);
        for (int i = 0; i < chest.k_(); ++i) {
            if (chest.a(i) == null || chest.a((int)i).c != up.aw.cj) continue;
            if (id == amq.E.cm) {
                chest.a((int)i).c = up.ax.cj;
            }
            if (id == amq.G.cm) {
                chest.a((int)i).c = up.ay.cj;
            }
            return true;
        }
        return false;
    }

    public void fountain() {
        if (this.k.G() % 10L == 0L) {
            this.pumpCharge = (short)(this.pumpCharge - 1);
        }
        int y = 0;
        for (int x = 1; x < 4; ++x) {
            if (this.k.a(this.l, this.m + x, this.n) != 0 && this.k.a(this.l, this.m + x, this.n) != amq.D.cm) continue;
            y = x;
        }
        if (y != 0) {
            this.k.d(this.l, this.m + y, this.n, amq.D.cm, 1);
        }
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.pumpCharge = nbttagcompound.d("pumpCharge");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("pumpCharge", this.pumpCharge);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= 200;
    }

    public boolean canHarvest() {
        if (!this.isPumpReady()) {
            return false;
        }
        return this.inventory[0] != null && (this.inventory[0].c == Ic2Items.cell.c || this.inventory[0].c == up.aw.cj) || this.isBucketInChestAvaible();
    }

    public boolean isBucketInChestAvaible() {
        return this.isBucketInChestAvaible(this.l, this.m + 1, this.n) || this.isBucketInChestAvaible(this.l, this.m - 1, this.n) || this.isBucketInChestAvaible(this.l + 1, this.m, this.n) || this.isBucketInChestAvaible(this.l - 1, this.m, this.n) || this.isBucketInChestAvaible(this.l, this.m, this.n + 1) || this.isBucketInChestAvaible(this.l, this.m, this.n - 1);
    }

    public boolean isBucketInChestAvaible(int x, int y, int z) {
        if (!(this.k.q(x, y, z) instanceof anm)) {
            return false;
        }
        anm chest = (anm)this.k.q(x, y, z);
        for (int i = 0; i < chest.k_(); ++i) {
            if (chest.a(i) == null || chest.a((int)i).c != up.aw.cj) continue;
            return true;
        }
        return false;
    }

    public boolean deliverLavaToGeo() {
        int lava = 3000;
        if (lava > 0 && this.k.q(this.l, this.m + 1, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.q(this.l, this.m + 1, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.q(this.l, this.m - 1, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.q(this.l, this.m - 1, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.q(this.l + 1, this.m, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.q(this.l + 1, this.m, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.q(this.l - 1, this.m, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.q(this.l - 1, this.m, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.q(this.l, this.m, this.n + 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.q(this.l, this.m, this.n + 1)).distributeLava(lava);
        }
        if (lava > 0 && this.k.q(this.l, this.m, this.n - 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.q(this.l, this.m, this.n - 1)).distributeLava(lava);
        }
        return lava < 2980;
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.machine.gui.GuiPump";
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

