/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.core.ContainerIC2;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.ContainerMatter;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityMatter
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int soundTicker = IC2.random.nextInt(32);
    public int scrap = 0;
    public static Vector amplifiers = new Vector();
    private final int StateIdle = 0;
    private final int StateRunning = 1;
    private final int StateRunningScrap = 2;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileEntityMatter() {
        super(2, 0, 1100000, 512);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.d("scrap");
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("scrap", this.scrap);
    }

    @Override
    public String b() {
        return "Mass Fabricator";
    }

    @Override
    public void g() {
        super.g();
        if (this.isRedstonePowered() || this.energy <= 0) {
            this.setState(0);
            this.setActive(false);
        } else {
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            boolean needsInvUpdate = false;
            if (this.scrap < 1000 && this.inventory[0] != null) {
                for (Map.Entry amplifier : amplifiers) {
                    if (!this.inventory[0].a((ur)amplifier.getKey())) continue;
                    if (((ur)amplifier.getKey()).b().s()) {
                        this.inventory[0] = ((ur)amplifier.getKey()).b().getContainerItemStack(this.inventory[0]);
                    } else {
                        --this.inventory[0].a;
                        if (this.inventory[0].a <= 0) {
                            this.inventory[0] = null;
                        }
                    }
                    this.scrap += ((Integer)amplifier.getValue()).intValue();
                    break;
                }
            }
            if (this.energy >= 1000000) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (needsInvUpdate) {
                this.d();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        if (this.inventory[1] == null) {
            this.inventory[1] = Ic2Items.matter.l();
            this.energy -= 1000000;
            return true;
        }
        if (!this.inventory[1].a(Ic2Items.matter) || this.inventory[1].a >= this.inventory[1].d()) {
            return false;
        }
        this.energy -= 1000000;
        ++this.inventory[1].a;
        return true;
    }

    @Override
    public int demandsEnergy() {
        if (this.isRedstonePowered()) {
            return 0;
        }
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            this.k.e(this.l, this.m, this.n, 0);
            ExplosionIC2 explosion = new ExplosionIC2(this.k, null, (float)this.l + 0.5f, (float)this.m + 0.5f, (float)this.n + 0.5f, 15.0f, 0.01f, 1.5f);
            explosion.doExplosion();
            return 0;
        }
        int bonus = amount;
        if (bonus > this.scrap) {
            bonus = this.scrap;
        }
        this.scrap -= bonus;
        this.energy += amount + 5 * bonus;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public int getMaxSafeInput() {
        return 512;
    }

    public String getProgressAsString() {
        int p = this.energy / 10000;
        if (p > 100) {
            p = 100;
        }
        return "" + p + "%";
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerMatter(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.machine.gui.GuiMatter";
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            IC2.network.updateTileEntityField(this, "state");
        }
        this.prevState = state;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.7f;
    }

    public boolean amplificationIsAvailable() {
        if (this.scrap > 0) {
            return true;
        }
        if (this.inventory[0] == null) {
            return false;
        }
        for (Map.Entry amplifier : amplifiers) {
            if (!this.inventory[0].a((ur)amplifier.getKey())) continue;
            return true;
        }
        return false;
    }
}

