/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.block.machine.ContainerElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public abstract class TileEntityElectricMachine
extends TileEntityElecMachine
implements IHasGui,
INetworkTileEntityEventListener,
ISidedInventory {
    public short progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float serverChargeLevel;
    public float serverProgress;
    public AudioSource audioSource;
    private static final int EventStart = 0;
    private static final int EventInterrupt = 1;
    private static final int EventStop = 2;

    public TileEntityElectricMachine(int slots, int e, int length, int maxinput) {
        super(slots + 4, 1, e * length + maxinput - 1, maxinput);
        this.defaultEnergyConsume = this.energyConsume = e;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = e * length;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.progress = nbttagcompound.d("progress");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("progress", this.progress);
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public float getProgress() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public void setProgress(float progress) {
        assert (!IC2.platform.isSimulating());
        this.serverProgress = progress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    public void d() {
        super.d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void g() {
        super.g();
        boolean canOperate = this.canOperate();
        boolean needsInvUpdate = false;
        if (this.energy <= this.energyConsume * this.operationLength && canOperate) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (this.progress >= this.operationLength) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
            IC2.network.initiateTileEntityEvent(this, 2, true);
        }
        canOperate = this.canOperate();
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= this.energyConsume) {
                    newActive = true;
                    IC2.network.initiateTileEntityEvent(this, 0, true);
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < this.energyConsume) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
            IC2.network.initiateTileEntityEvent(this, 1, true);
        }
        if (newActive) {
            this.progress = (short)(this.progress + 1);
            this.energy -= this.energyConsume;
        }
        if (needsInvUpdate) {
            this.d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void setOverclockRates() {
        int overclockerUpgradeCount = 0;
        int transformerUpgradeCount = 0;
        int energyStorageUpgradeCount = 0;
        for (int i = 0; i < 4; ++i) {
            ur itemStack = this.inventory[i + this.inventory.length - 4];
            if (itemStack == null) continue;
            if (itemStack.a(Ic2Items.overclockerUpgrade)) {
                overclockerUpgradeCount += itemStack.a;
                continue;
            }
            if (itemStack.a(Ic2Items.transformerUpgrade)) {
                transformerUpgradeCount += itemStack.a;
                continue;
            }
            if (!itemStack.a(Ic2Items.energyStorageUpgrade)) continue;
            energyStorageUpgradeCount += itemStack.a;
        }
        if (overclockerUpgradeCount > 32) {
            overclockerUpgradeCount = 32;
        }
        if (transformerUpgradeCount > 10) {
            transformerUpgradeCount = 10;
        }
        double previousProgress = (double)this.progress / (double)this.operationLength;
        this.energyConsume = (int)((double)this.defaultEnergyConsume * Math.pow(1.6, overclockerUpgradeCount));
        this.operationLength = (int)Math.round((double)this.defaultOperationLength * Math.pow(0.7, overclockerUpgradeCount));
        this.maxInput = this.defaultMaxInput * (int)Math.pow(4.0, transformerUpgradeCount);
        this.maxEnergy = this.defaultEnergyStorage + energyStorageUpgradeCount * 10000 + this.maxInput - 1;
        this.tier = transformerUpgradeCount + 1;
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.round(previousProgress * (double)this.operationLength);
    }

    @Override
    public boolean provideEnergy() {
        if (this.inventory[this.fuelslot] != null && this.inventory[this.fuelslot].b() == up.aC) {
            this.energy += this.defaultEnergyConsume * this.defaultOperationLength;
            --this.inventory[this.fuelslot].a;
            if (this.inventory[this.fuelslot].a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return super.provideEnergy();
    }

    public void operate() {
        ur processResult;
        if (!this.canOperate()) {
            return;
        }
        if (this.inventory[0].b().s()) {
            processResult = this.getResultFor(this.inventory[0], false).l();
            this.inventory[0] = this.inventory[0].b().getContainerItemStack(this.inventory[0]);
        } else {
            processResult = this.getResultFor(this.inventory[0], true).l();
        }
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = processResult;
        } else {
            this.inventory[2].a += processResult.a;
        }
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ur processResult = this.getResultFor(this.inventory[0], false);
        if (processResult == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].a(processResult)) {
            return false;
        }
        return this.inventory[2].a + processResult.a <= this.inventory[2].d();
    }

    public abstract ur getResultFor(ur var1, boolean var2);

    @Override
    public abstract String b();

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerElectricMachine(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce(this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
            case UP: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

