/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.vector.Vector3;

public class Electricity {
    public static Electricity instance = new Electricity();
    private List electricityNetworks = new ArrayList();

    public void registerConductor(IConductor newConductor) {
        this.cleanUpNetworks();
        ElectricityNetwork newNetwork = new ElectricityNetwork(newConductor);
        this.electricityNetworks.add(newNetwork);
    }

    public void unregister(any tileEntity) {
        for (ElectricityNetwork network : this.electricityNetworks) {
            network.stopProducing(tileEntity);
            network.stopRequesting(tileEntity);
        }
    }

    public void mergeConnection(ElectricityNetwork networkA, ElectricityNetwork networkB) {
        if (networkA != networkB) {
            if (networkA != null && networkB != null) {
                networkA.conductors.addAll(networkB.conductors);
                networkA.setNetwork();
                this.electricityNetworks.remove(networkB);
                networkB = null;
                networkA.cleanConductors();
            } else {
                System.err.println("Failed to merge Universal Electricity wire connections!");
            }
        }
    }

    public void splitConnection(IConductor conductorA, IConductor conductorB) {
        try {
            ElectricityNetwork network = conductorA.getNetwork();
            if (network != null) {
                network.cleanConductors();
                network.resetConductors();
                for (IConductor conductor : network.conductors) {
                    for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                        conductor.updateConnectionWithoutSplit(Vector3.getConnectorFromSide(((any)conductor).k, new Vector3((any)conductor), ForgeDirection.getOrientation((int)i)), ForgeDirection.getOrientation((int)i));
                    }
                }
            } else {
                FMLLog.severe((String)"Conductor invalid network while splitting connection!", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to split wire connection!", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void cleanUpNetworks() {
        try {
            Iterator it = this.electricityNetworks.iterator();
            while (it.hasNext()) {
                ElectricityNetwork network = (ElectricityNetwork)it.next();
                network.cleanConductors();
                if (network.conductors.size() != 0) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to clean up wire connections!", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void resetConductors() {
        for (ElectricityNetwork network : this.electricityNetworks) {
            network.resetConductors();
        }
    }
}

