/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.modules;

import java.util.Arrays;
import net.machinemuse.api.ElectricItemUtils;
import net.machinemuse.api.IPlayerTickModule;
import net.machinemuse.api.IToggleableModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.modules.PowerModuleBase;

public class SprintAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public SprintAssistModule() {
        super(Arrays.asList(ModularPowersuits.powerArmorLegs));
        this.addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 4));
        this.addSimpleTradeoff(this, "Power", "Sprint Energy Consumption", "J", 0.0, 10.0, "Sprint Speed Multiplier", "%", 1.0, 2.0);
        this.addSimpleTradeoff(this, "Compensation", "Sprint Energy Consumption", "J", 0.0, 2.0, "Sprint Exhaustion Compensation", "%", 0.0, 1.0);
        this.addSimpleTradeoff(this, "Walking Assist", "Walking Energy Consumption", "J", 0.0, 10.0, "Walking Speed Multiplier", "%", 1.0, 1.0);
    }

    @Override
    public MuseIcon getIcon(ur item) {
        return MuseIcon.SPRINT_ASSIST;
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return "Sprint Assist";
    }

    @Override
    public String getDescription() {
        return "A set of servo motors to help you sprint (double-tap forward) and walk faster.";
    }

    @Override
    public void onPlayerTickActive(qx player, ur item) {
        double horzMovement = Math.sqrt(player.w * player.w + player.y * player.y);
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        if (player.ai()) {
            double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
            double sprintCost = ModuleManager.computeModularProperty(item, "Sprint Energy Consumption");
            if (sprintCost < totalEnergy) {
                double sprintMultiplier = ModuleManager.computeModularProperty(item, "Sprint Speed Multiplier");
                double exhaustionComp = ModuleManager.computeModularProperty(item, "Sprint Exhaustion Compensation");
                ElectricItemUtils.drainPlayerEnergy(player, sprintCost * horzMovement * 5.0);
                player.aN = (float)((double)player.aN * sprintMultiplier);
                player.cc().a((float)(-0.01 * exhaustion * exhaustionComp));
                player.aO = player.aN * 0.5f;
            }
        } else {
            double cost = ModuleManager.computeModularProperty(item, "Walking Energy Consumption");
            if (cost < totalEnergy) {
                double walkMultiplier = ModuleManager.computeModularProperty(item, "Walking Speed Multiplier");
                ElectricItemUtils.drainPlayerEnergy(player, cost * horzMovement * 5.0);
                player.aN = (float)((double)player.aN * walkMultiplier);
                player.aO = player.aN * 0.5f;
            }
        }
    }

    @Override
    public void onPlayerTickInactive(qx player, ur item) {
    }
}

