/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network;

import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MuseLogger;
import net.machinemuse.powersuits.network.MusePacketHandler;

public abstract class MusePacket {
    protected static final int READ_ERROR = -150;
    protected Player player;
    protected ByteArrayOutputStream bytes;
    protected di packet;
    protected DataOutputStream dataout;
    protected DataInputStream datain;
    protected int id;

    protected MusePacket(Player player) {
        this.player = player;
        this.bytes = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.bytes);
        int id = MusePacketHandler.getTypeID(this);
        this.writeInt(id);
    }

    protected MusePacket(DataInputStream data, Player player) {
        this.player = player;
        this.datain = data;
    }

    public di getPacket250() {
        byte[] output = this.bytes.toByteArray();
        return new di(Config.getNetworkChannelName(), this.bytes.toByteArray());
    }

    public abstract void handleClient(ays var1);

    public abstract void handleServer(iq var1);

    public int readInt() {
        try {
            int read = this.datain.readInt();
            return read;
        }
        catch (IOException e) {
            MuseLogger.logError("PROBLEM READING INT FROM PACKET D:");
            e.printStackTrace();
            return -150;
        }
    }

    public void writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean readBoolean() {
        try {
            boolean read = this.datain.readBoolean();
            return read;
        }
        catch (IOException e) {
            MuseLogger.logError("PROBLEM READING DOUBLE FROM PACKET D:");
            e.printStackTrace();
            return false;
        }
    }

    public void writeBoolean(boolean val) {
        try {
            this.dataout.writeBoolean(val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double readDouble() {
        try {
            double read = this.datain.readDouble();
            return read;
        }
        catch (IOException e) {
            MuseLogger.logError("PROBLEM READING DOUBLE FROM PACKET D:");
            e.printStackTrace();
            return -150.0;
        }
    }

    public void writeDouble(double i) {
        try {
            this.dataout.writeDouble(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ur readItemStack() {
        ur stack = null;
        try {
            short itemID = this.datain.readShort();
            if (itemID >= 0) {
                byte stackSize = this.datain.readByte();
                short damageAmount = this.datain.readShort();
                stack = new ur((int)itemID, (int)stackSize, (int)damageAmount);
                stack.d = this.readNBTTagCompound();
            }
        }
        catch (IOException e) {
            MuseLogger.logError("Problem reading itemstack D:");
            e.printStackTrace();
        }
        return stack;
    }

    public void writeItemStack(ur stack) {
        try {
            if (stack == null) {
                this.dataout.writeShort(-1);
            } else {
                this.dataout.writeShort(stack.c);
                this.dataout.writeByte(stack.a);
                this.dataout.writeShort(stack.j());
                bq nbt = null;
                if (stack.b().n() || stack.b().q()) {
                    nbt = stack.d;
                }
                this.writeNBTTagCompound(nbt);
            }
        }
        catch (IOException e) {
            MuseLogger.logError("Problem writing itemstack D:");
            e.printStackTrace();
        }
    }

    public bq readNBTTagCompound() throws IOException {
        short length = this.datain.readShort();
        if (length < 0) {
            return null;
        }
        byte[] fullData = new byte[length];
        this.datain.readFully(fullData);
        return ca.a((byte[])fullData);
    }

    protected void writeNBTTagCompound(bq nbt) throws IOException {
        if (nbt == null) {
            this.dataout.writeShort(-1);
        } else {
            byte[] compressednbt = ca.a((bq)nbt);
            this.dataout.writeShort((short)compressednbt.length);
            this.dataout.write(compressednbt);
        }
    }

    public void writeString(String string) {
        try {
            this.dataout.writeShort(string.length());
            this.dataout.writeChars(string);
        }
        catch (IOException e) {
            MuseLogger.logError("String too big D:");
            e.printStackTrace();
        }
    }

    public String readString(int maxlength) {
        String read = null;
        try {
            int length = this.datain.readShort();
            if (length > maxlength) {
                throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxlength + ")");
            }
            if (length < 0) {
                throw new IOException("Received string length is less than zero! Weird string!");
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                builder.append(this.datain.readChar());
            }
            read = builder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return read;
    }
}

