/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.ICustomElectricItem;
import icbm.api.explosion.IEMPItem;
import icbm.api.explosion.IExplosive;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ElectricItemUtils;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IRightClickModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseCommonStrings;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.network.packets.MusePacketPlasmaBolt;
import net.minecraftforge.common.ForgeHooks;
import thermalexpansion.api.core.IChargeableItem;
import universalelectricity.core.electricity.ElectricInfo;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IItemElectric;

public class ItemPowerTool
extends tw
implements IModularItem,
IItemElectric,
ICustomElectricItem,
IEMPItem,
IChargeableItem {
    public static final ur ironPickaxe = new ur(up.g);
    public static final ur ironAxe = new ur(up.h);
    public static final ur ironShovel = new ur(up.f);
    public static final ur diamondPick = new ur(up.B);

    public ItemPowerTool() {
        super(Config.getAssignedItemID(Config.Items.PowerTool), 0, uq.d, new amq[0]);
        this.d(1);
        this.e(0);
        this.co = 1;
        this.a(Config.getCreativeTab());
        this.c(59);
        this.setTextureFile("/resources/machinemuse/watericons.png");
        this.b(Config.Items.PowerTool.idName);
        LanguageRegistry.addName((Object)this, (String)Config.Items.PowerTool.englishName);
    }

    @Override
    public Config.Items getItemType() {
        return Config.Items.PowerTool;
    }

    public float a(ur stack, amq block) {
        return this.getStrVsBlock(stack, block, 0);
    }

    public static Colour getColorFromItemStack(ur stack) {
        double computedred = ModuleManager.computeModularProperty(stack, "Red Tint");
        double computedgreen = ModuleManager.computeModularProperty(stack, "Green Tint");
        double computedblue = ModuleManager.computeModularProperty(stack, "Blue Tint");
        Colour colour = new Colour(ItemPowerTool.clampDouble(1.0 + computedred - (computedblue + computedgreen), 0.0, 1.0), ItemPowerTool.clampDouble(1.0 + computedgreen - (computedblue + computedred), 0.0, 1.0), ItemPowerTool.clampDouble(1.0 + computedblue - (computedred + computedgreen), 0.0, 1.0), 1.0);
        return colour;
    }

    public static double clampDouble(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static boolean canHarvestBlock(ur stack, amq block, int meta, qx player) {
        if (player != null) {
            double energy = ElectricItemUtils.getPlayerEnergy(player);
            if (ItemPowerTool.useIronPickaxe(stack, block, meta) && energy > ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption")) {
                return true;
            }
            if (ItemPowerTool.useIronShovel(stack, block, meta) && energy > ModuleManager.computeModularProperty(stack, "Shovel Energy Consumption")) {
                return true;
            }
            if (ItemPowerTool.useIronAxe(stack, block, meta) && energy > ModuleManager.computeModularProperty(stack, "Axe Energy Consumption")) {
                return true;
            }
            return ItemPowerTool.useDiamondPickaxe(stack, block, meta) && energy > ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption");
        }
        return false;
    }

    public float getStrVsBlock(ur stack, amq block, int meta) {
        return 1.0f;
    }

    public boolean a(ur stack, md entityBeingHit, md entityDoingHitting) {
        if (entityDoingHitting instanceof qx && MuseItemUtils.itemHasActiveModule(stack, "Melee Assist")) {
            qx player = (qx)entityDoingHitting;
            double drain = ModuleManager.computeModularProperty(stack, "Punch Energy Consumption");
            if (ElectricItemUtils.getPlayerEnergy(player) > drain) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                double damage = ModuleManager.computeModularProperty(stack, "Melee Damage");
                double knockback = ModuleManager.computeModularProperty(stack, "Melee Knockback");
                lh damageSource = lh.a((qx)player);
                if (entityBeingHit.a(damageSource, (int)damage)) {
                    aoj lookVec = player.Z();
                    entityBeingHit.g(lookVec.c * knockback, Math.abs(lookVec.d + (double)0.2f) * knockback, lookVec.e * knockback);
                }
            }
        }
        return true;
    }

    public boolean a(ur stack, yc world, int blockID, int x, int y, int z, md entity) {
        double drain = 1.0;
        amq block = amq.p[blockID];
        int meta = 0;
        drain = ItemPowerTool.useIronPickaxe(stack, block, meta) ? ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption") : (ItemPowerTool.useIronShovel(stack, block, meta) ? ModuleManager.computeModularProperty(stack, "Shovel Energy Consumption") : (ItemPowerTool.useIronAxe(stack, block, meta) ? ModuleManager.computeModularProperty(stack, "Axe Energy Consumption") : (ItemPowerTool.useDiamondPickaxe(stack, block, meta) ? ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption") : 0.0)));
        if (drain > 0.0 && entity.a(agi.h) && MuseItemUtils.itemHasActiveModule(stack, "Aqua Affinity")) {
            drain += ModuleManager.computeModularProperty(stack, "Underwater Energy Consumption");
        }
        if (entity instanceof qx) {
            qx player = (qx)entity;
            ElectricItemUtils.drainPlayerEnergy(player, drain);
        } else {
            this.onUse(drain, stack);
        }
        return true;
    }

    public static boolean useIronPickaxe(ur stack, amq block, int meta) {
        if (MuseItemUtils.itemHasActiveModule(stack, "Pickaxe")) {
            if (ForgeHooks.isToolEffective((ur)ironPickaxe, (amq)block, (int)meta)) {
                return true;
            }
            if (!(ForgeHooks.isToolEffective((ur)diamondPick, (amq)block, (int)meta) || block.cB != agi.f && block.cB != agi.g && block.cB != agi.e)) {
                return true;
            }
        }
        return false;
    }

    public static boolean useIronShovel(ur stack, amq block, int meta) {
        if (MuseItemUtils.itemHasActiveModule(stack, "Shovel")) {
            if (ForgeHooks.isToolEffective((ur)ironShovel, (amq)block, (int)meta)) {
                return true;
            }
            if (block.cB == agi.w) {
                return true;
            }
        }
        return false;
    }

    public static boolean useIronAxe(ur stack, amq block, int meta) {
        if (MuseItemUtils.itemHasActiveModule(stack, "Axe")) {
            if (ForgeHooks.isToolEffective((ur)ironAxe, (amq)block, (int)meta)) {
                return true;
            }
            if (block.cB == agi.d || block.cB == agi.k || block.cB == agi.l) {
                return true;
            }
        }
        return false;
    }

    public static boolean useDiamondPickaxe(ur stack, amq block, int meta) {
        if (MuseItemUtils.itemHasActiveModule(stack, "Diamond Drill Upgrade")) {
            if (ForgeHooks.isToolEffective((ur)diamondPick, (amq)block, (int)meta)) {
                return true;
            }
            if (block.cB == agi.f || block.cB == agi.g || block.cB == agi.e) {
                return true;
            }
        }
        return false;
    }

    public int a(lq par1Entity) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean n_() {
        return true;
    }

    public int c() {
        return 0;
    }

    public String g() {
        return this.b.toString();
    }

    public boolean a(ur par1ItemStack, ur par2ItemStack) {
        return false;
    }

    public static String formatInfo(String string, double value) {
        return string + "\t" + MuseStringUtils.formatNumberShort(value);
    }

    @Override
    public List getLongInfo(qx player, ur stack) {
        ArrayList<String> info = new ArrayList<String>();
        bq itemProperties = MuseItemUtils.getMuseItemTag(stack);
        info.add("Detailed Summary");
        info.add(ItemPowerTool.formatInfo("Energy Storage", this.getMaxJoules(stack)) + "J");
        info.add(ItemPowerTool.formatInfo("Weight", MuseCommonStrings.getTotalWeight(stack)) + "g");
        return info;
    }

    public void a(ur stack, qx player, List currentTipList, boolean advancedToolTips) {
        MuseCommonStrings.addInformation(stack, player, currentTipList, advancedToolTips);
    }

    public int c_(ur par1ItemStack) {
        return 72000;
    }

    public ur b(ur par1ItemStack, yc par2World, qx par3EntityPlayer) {
        return par1ItemStack;
    }

    public ur a(ur itemStack, yc world, qx player) {
        for (IRightClickModule module : ModuleManager.getRightClickModules()) {
            if (!module.isValidForItem(itemStack, player) || !MuseItemUtils.itemHasActiveModule(itemStack, module.getName())) continue;
            module.onRightClick(player, world, itemStack);
        }
        return itemStack;
    }

    public vs b_(ur stack) {
        return vs.e;
    }

    public void a(ur itemStack, yc world, qx player, int par4) {
        int chargeTicks = Math.max(this.c_(itemStack) - par4, 10);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, "Plasma Energy Per Tick") * (double)chargeTicks;
            if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
                double explosiveness = ModuleManager.computeModularProperty(itemStack, "Plasma Explosiveness");
                double damagingness = ModuleManager.computeModularProperty(itemStack, "Plasma Damage At Full Charge");
                EntityPlasmaBolt plasmaBolt = new EntityPlasmaBolt(world, (md)player, explosiveness, damagingness, chargeTicks);
                world.d((lq)plasmaBolt);
                MusePacketPlasmaBolt packet = new MusePacketPlasmaBolt((Player)player, plasmaBolt.k, plasmaBolt.size);
                PacketDispatcher.sendPacketToAllPlayers((ef)packet.getPacket250());
            }
        }
    }

    @Override
    public double onReceive(double amps, double voltage, ur itemStack) {
        double amount = ElectricInfo.getJoules(amps, voltage, 1.0);
        return ElectricItemUtils.charge(amount, itemStack);
    }

    @Override
    public double onUse(double joulesNeeded, ur itemStack) {
        return ElectricItemUtils.discharge(joulesNeeded, itemStack);
    }

    @Override
    public double getJoules(Object ... data) {
        return ElectricItemUtils.getJoules(this.getAsStack(data));
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        ElectricItemUtils.setJoules(joules, this.getAsStack(data));
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return ElectricItemUtils.getMaxJoules(this.getAsStack(data));
    }

    @Override
    public double getVoltage(Object ... data) {
        return ElectricItemUtils.getVoltage(this.getAsStack(data));
    }

    @Override
    public boolean canReceiveElectricity() {
        return true;
    }

    @Override
    public boolean canProduceElectricity() {
        return true;
    }

    private ur getAsStack(Object[] data) {
        if (data[0] instanceof ur) {
            return (ur)data[0];
        }
        throw new IllegalArgumentException("MusePowerSuits: Invalid ItemStack passed via UE interface");
    }

    @Override
    public int charge(ur stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double joulesProvided = ModCompatability.joulesFromEU(amount);
        double currentJoules = ElectricItemUtils.getJoules(stack);
        double surplus = ElectricItemUtils.charge(joulesProvided, stack);
        if (simulate) {
            ElectricItemUtils.setJoules(currentJoules, stack);
        }
        return ModCompatability.joulesToEU(joulesProvided - surplus);
    }

    @Override
    public int discharge(ur stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double joulesRequested = ModCompatability.joulesFromEU(amount);
        double currentJoules = ElectricItemUtils.getJoules(stack);
        double givenJoules = ElectricItemUtils.discharge(joulesRequested, stack);
        if (simulate) {
            ElectricItemUtils.setJoules(currentJoules, stack);
        }
        return ModCompatability.joulesToEU(givenJoules);
    }

    @Override
    public boolean canUse(ur stack, int amount) {
        double joulesRequested = ModCompatability.joulesFromEU(amount);
        double currentJoules = ElectricItemUtils.getJoules(stack);
        return currentJoules > joulesRequested;
    }

    @Override
    public boolean canShowChargeToolTip(ur itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy() {
        return true;
    }

    @Override
    public int getChargedItemId() {
        return this.cj;
    }

    @Override
    public int getEmptyItemId() {
        return this.cj;
    }

    @Override
    public int getMaxCharge() {
        return 1;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public int getTransferLimit() {
        return 0;
    }

    public static MuseIcon getCurrentIconFor(ur itemStack) {
        return MuseIcon.POWERTOOL;
    }

    public boolean onItemUseFirst(ur itemStack, qx player, yc worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        any tileEntity;
        if (ModCompatability.isBasicComponentsLoaded() && MuseItemUtils.itemHasActiveModule(itemStack, "Multimeter") && !worldObj.I && (tileEntity = worldObj.q(x, y, z)) instanceof IConductor) {
            IConductor wireTile = (IConductor)tileEntity;
            ElectricityPack getProduced = wireTile.getNetwork().getProduced(new any[0]);
            player.b("Reading: " + ElectricInfo.getDisplay(getProduced.amperes, ElectricInfo.ElectricUnit.AMPERE) + ", " + ElectricInfo.getDisplay(getProduced.voltage, ElectricInfo.ElectricUnit.VOLTAGE) + ", " + ElectricInfo.getDisplay(getProduced.getWatts() * 20.0, ElectricInfo.ElectricUnit.WATT));
            return true;
        }
        return false;
    }

    @Override
    public void onEMP(ur itemStack, lq entity, IExplosive empExplosive) {
        ElectricItemUtils.onEMP(itemStack, entity, empExplosive);
    }

    @Override
    public float receiveEnergy(ur stack, float energy, boolean doReceive) {
        double offeredJoules = (double)energy * ModCompatability.getBCRatio();
        double missingJoules = ElectricItemUtils.getMaxJoules(stack) - ElectricItemUtils.getJoules(stack);
        double transferredJoules = Math.min(offeredJoules, missingJoules);
        ElectricItemUtils.charge(transferredJoules, stack);
        return (float)(transferredJoules / ModCompatability.getBCRatio());
    }

    @Override
    public float transferEnergy(ur stack, float energy, boolean doTransfer) {
        double requestedJoules = (double)energy * ModCompatability.getBCRatio();
        double availableJoules = ElectricItemUtils.getJoules(stack);
        double transferredJoules = Math.min(requestedJoules, availableJoules);
        ElectricItemUtils.discharge(transferredJoules, stack);
        return (float)(transferredJoules / ModCompatability.getBCRatio());
    }

    @Override
    public float getEnergyStored(ur stack) {
        return (float)(ModCompatability.getBCRatio() * ElectricItemUtils.getJoules(stack));
    }

    @Override
    public float getMaxEnergyStored(ur stack) {
        return (float)(ModCompatability.getBCRatio() * ElectricItemUtils.getMaxJoules(stack));
    }
}

