/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.Clickable;

public class ClickableModule
extends Clickable {
    protected IPowerModule module;

    public ClickableModule(IPowerModule module2, MusePoint2D position) {
        super(position);
        this.setModule(module2);
    }

    @Override
    public List getToolTip() {
        ArrayList<String> toolTipText = new ArrayList<String>();
        toolTipText.add(this.getModule().getName());
        toolTipText.addAll(MuseStringUtils.wrapStringToLength(this.getModule().getDescription(), 30));
        return toolTipText;
    }

    @Override
    public void draw() {
        Colour c1 = new Colour(1.0, 0.2f, 0.6f, 1.0);
        Colour c2 = new Colour(0.6f, 0.2f, 1.0, 1.0);
        Colour.getGreyscale(1.0f, 1.0f).doGL();
        MuseRenderer.drawIconAt(this.getPosition().x() - 8.0, this.getPosition().y() - 8.0, this.getModule().getIcon(null), null);
    }

    @Override
    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(x - this.getPosition().x()) < 8.0;
        boolean hity = Math.abs(y - this.getPosition().y()) < 8.0;
        return hitx && hity;
    }

    public IPowerModule getModule() {
        return this.module;
    }

    public ClickableModule setModule(IPowerModule module2) {
        this.module = module2;
        return this;
    }

    public boolean equals(ClickableModule other) {
        return this.module.equals(other.module);
    }
}

