/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.geometry;

import net.machinemuse.general.geometry.FlyFromPointToPoint2D;
import net.machinemuse.general.geometry.MusePoint2D;

public class MuseRect {
    MusePoint2D ul;
    MusePoint2D br;

    public MuseRect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this.ul = new MusePoint2D(left, top);
        this.br = new MusePoint2D(right, bottom);
        if (growFromMiddle) {
            MusePoint2D center = this.ul.plus(this.br).times(0.5);
            this.ul = new FlyFromPointToPoint2D(center, this.ul, 200.0);
            this.br = new FlyFromPointToPoint2D(center, this.br, 200.0);
        }
    }

    public MuseRect(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public MuseRect(MusePoint2D ul, MusePoint2D br) {
        this.ul = ul;
        this.br = br;
    }

    public double left() {
        return this.ul.x();
    }

    public double right() {
        return this.br.x();
    }

    public double top() {
        return this.ul.y();
    }

    public double bottom() {
        return this.br.y();
    }

    public MuseRect setLeft(double value) {
        this.ul.x = value;
        return this;
    }

    public MuseRect setRight(double value) {
        this.br.x = value;
        return this;
    }

    public MuseRect setTop(double value) {
        this.ul.y = value;
        return this;
    }

    public MuseRect setBottom(double value) {
        this.br.y = value;
        return this;
    }

    public boolean equals(MuseRect other) {
        return this.ul.equals(other.ul) && this.br.equals(other.br);
    }
}

