/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.geometry;

import org.lwjgl.opengl.GL11;

public class Colour {
    public static final Colour LIGHTBLUE = new Colour(0.5, 0.5, 1.0, 1.0);
    public static final Colour DARKBLUE = new Colour(0.0, 0.0, 0.5, 1.0);
    public static final Colour ORANGE = new Colour(0.9, 0.6, 0.2, 1.0);
    public static final Colour YELLOW = new Colour(0.0, 0.0, 0.5, 1.0);
    public static final Colour WHITE = new Colour(1.0, 1.0, 1.0, 1.0);
    public double r;
    public double g;
    public double b;
    public double a;

    public Colour(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Colour(float r, float g, float b) {
        this(r, g, b, 1.0);
    }

    public Colour(int c) {
        this.a = (float)(c >> 24 & 0xFF) / 255.0f;
        this.r = (float)(c >> 16 & 0xFF) / 255.0f;
        this.g = (float)(c >> 8 & 0xFF) / 255.0f;
        this.b = (float)(c & 0xFF) / 255.0f;
    }

    public int getInt() {
        int val = 0;
        val |= (int)(this.a * 255.0) << 24;
        val |= (int)(this.r * 255.0) << 16;
        val |= (int)(this.g * 255.0) << 8;
        return val |= (int)(this.b * 255.0);
    }

    public static Colour getGreyscale(float value, float alpha) {
        return new Colour(value, value, value, alpha);
    }

    public Colour interpolate(Colour target, double d) {
        double complement = 1.0 - d;
        return new Colour(this.r * complement + target.r * d, this.g * complement + target.g * d, this.b * complement + target.b * d, this.a * complement + target.a * d);
    }

    public void doGL() {
        GL11.glColor4d((double)this.r, (double)this.g, (double)this.b, (double)this.a);
    }

    public Colour withAlpha(double newalpha) {
        return new Colour(this.r, this.g, this.b, newalpha);
    }

    public double[] asArray() {
        return new double[]{this.r, this.g, this.b, this.a};
    }
}

