/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IRightClickModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.MuseMathUtils;
import net.machinemuse.powersuits.item.ItemComponent;

public class MuseItemUtils {
    public static final String NBTPREFIX = "mmmpsmod";
    public static final String ONLINE = "Active";

    public static List getValidModulesForItem(qx player, ur stack) {
        ArrayList<IPowerModule> validModules = new ArrayList<IPowerModule>();
        for (IPowerModule module : ModuleManager.getAllModules()) {
            if (!module.isValidForItem(stack, player)) continue;
            validModules.add(module);
        }
        return validModules;
    }

    public static boolean tagHasModule(bq tag, String moduleName) {
        return tag.b(moduleName);
    }

    public static List getValidModes(ur stack, qx player) {
        ArrayList<String> modes = new ArrayList<String>();
        if (stack.b() instanceof IModularItem) {
            for (IPowerModule module : ModuleManager.getAllModules()) {
                if (!module.isValidForItem(stack, player) || !(module instanceof IRightClickModule)) continue;
                modes.add(module.getName());
            }
        }
        return modes;
    }

    public static List getModes(ur stack, qx player) {
        ArrayList<String> modes = new ArrayList<String>();
        if (stack.b() instanceof IModularItem) {
            for (IPowerModule module : ModuleManager.getAllModules()) {
                if (!module.isValidForItem(stack, player) || !(module instanceof IRightClickModule) || !MuseItemUtils.itemHasModule(stack, module.getName())) continue;
                modes.add(module.getName());
            }
        }
        return modes;
    }

    public static boolean isModuleOnline(bq itemTag, String moduleName) {
        if (MuseItemUtils.tagHasModule(itemTag, moduleName) && !itemTag.l(moduleName).b(ONLINE)) {
            return true;
        }
        return MuseItemUtils.tagHasModule(itemTag, moduleName) && itemTag.l(moduleName).n(ONLINE);
    }

    public static void toggleModule(bq itemTag, String name, boolean toggleval) {
        if (MuseItemUtils.tagHasModule(itemTag, name)) {
            bq moduleTag = itemTag.l(name);
            moduleTag.a(ONLINE, toggleval);
        }
    }

    public static boolean itemHasModule(ur stack, String moduleName) {
        return MuseItemUtils.tagHasModule(MuseItemUtils.getMuseItemTag(stack), moduleName);
    }

    public static void tagAddModule(bq tag, IPowerModule module) {
        tag.a(module.getName(), module.getNewTag());
    }

    public static void itemAddModule(ur stack, IPowerModule moduleType) {
        MuseItemUtils.tagAddModule(MuseItemUtils.getMuseItemTag(stack), moduleType);
    }

    public static boolean removeModule(bq tag, String moduleName) {
        if (tag.b(moduleName)) {
            tag.o(moduleName);
            return true;
        }
        return false;
    }

    public static boolean removeModule(ur stack, String moduleName) {
        return MuseItemUtils.removeModule(MuseItemUtils.getMuseItemTag(stack), moduleName);
    }

    public static bq getMuseItemTag(ur stack) {
        bq properties;
        bq stackTag;
        if (stack == null) {
            return null;
        }
        if (stack.o()) {
            stackTag = stack.p();
        } else {
            stackTag = new bq();
            stack.d(stackTag);
        }
        if (stackTag.b(NBTPREFIX)) {
            properties = stackTag.l(NBTPREFIX);
        } else {
            properties = new bq();
            stackTag.a(NBTPREFIX, properties);
        }
        return properties;
    }

    public static List getModularItemsInInventory(la inv) {
        ArrayList<ur> stacks = new ArrayList<ur>();
        for (int i = 0; i < inv.k_(); ++i) {
            ur stack = inv.a(i);
            if (stack == null || !(stack.b() instanceof IModularItem)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static List getModularItemsInInventory(qx player) {
        return MuseItemUtils.getModularItemsInInventory((la)player.bJ);
    }

    public static List getModularItemSlotsInInventory(la inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < inv.k_(); ++i) {
            ur stack = inv.a(i);
            if (stack == null || !(stack.b() instanceof IModularItem)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static IModularItem getAsModular(up item) {
        if (item instanceof IModularItem) {
            return (IModularItem)item;
        }
        return null;
    }

    public static boolean hasInInventory(List workingUpgradeCost, qw inventory) {
        for (ur stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.k_(); ++i) {
                ur stackInInventory = inventory.a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.a;
            }
            if (found >= stackInCost.a) continue;
            return false;
        }
        return true;
    }

    public static List deleteFromInventory(List cost, qw inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ur stackInCost : cost) {
            int remaining = stackInCost.a;
            for (int i = 0; i < inventory.k_() && remaining > 0; ++i) {
                ur stackInInventory = inventory.a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                int numToTake = Math.min(stackInInventory.a, remaining);
                stackInInventory.a -= numToTake;
                remaining -= numToTake;
                if (stackInInventory.a == 0) {
                    inventory.a(i, null);
                }
                slots.add(i);
            }
        }
        return slots;
    }

    public static List findInInventoryForCost(List workingUpgradeCost, qw inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ur stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.k_() && found < stackInCost.a; ++i) {
                ur stackInInventory = inventory.a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.a;
                slots.add(i);
            }
        }
        return slots;
    }

    public static double getDoubleOrZero(bq itemProperties, String string) {
        double value = 0.0;
        if (itemProperties != null && itemProperties.b(string)) {
            value = itemProperties.h(string);
        }
        return value;
    }

    public static double getDoubleOrZero(ur stack, String string) {
        return MuseItemUtils.getDoubleOrZero(MuseItemUtils.getMuseItemTag(stack), string);
    }

    public static void setDoubleOrRemove(bq itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.o(string);
            } else {
                itemProperties.a(string, value);
            }
        }
    }

    public static void setDoubleOrRemove(ur stack, String string, double value) {
        MuseItemUtils.setDoubleOrRemove(MuseItemUtils.getMuseItemTag(stack), string, value);
    }

    public static String getStringOrNull(bq itemProperties, String key) {
        String value = null;
        if (itemProperties != null && itemProperties.b(key)) {
            value = itemProperties.i(key);
        }
        return value;
    }

    public static String getStringOrNull(ur stack, String key) {
        return MuseItemUtils.getStringOrNull(MuseItemUtils.getMuseItemTag(stack), key);
    }

    public static void setStringOrNull(bq itemProperties, String key, String value) {
        if (itemProperties != null) {
            if (value.equals("")) {
                itemProperties.o(key);
            } else {
                itemProperties.a(key, value);
            }
        }
    }

    public static void setStringOrNull(ur stack, String key, String value) {
        MuseItemUtils.setStringOrNull(MuseItemUtils.getMuseItemTag(stack), key, value);
    }

    public static double getFoodLevel(ur stack) {
        bq itemTag;
        Double foodLevel;
        if (stack != null && stack.b() instanceof IModularItem && (foodLevel = Double.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).h("Food"))) != null) {
            return foodLevel;
        }
        return 0.0;
    }

    public static void setFoodLevel(ur stack, double d) {
        if (stack != null && stack.b() instanceof IModularItem) {
            bq itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.a("Food", d);
        }
    }

    public static double getSaturationLevel(ur stack) {
        bq itemTag;
        Double saturationLevel;
        if (stack != null && stack.b() instanceof IModularItem && (saturationLevel = Double.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).h("Saturation"))) != null) {
            return saturationLevel;
        }
        return 0.0;
    }

    public static void setSaturationLevel(ur stack, double d) {
        if (stack != null && stack.b() instanceof IModularItem) {
            bq itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.a("Saturation", d);
        }
    }

    public static List modularItemsEquipped(qx player) {
        ur[] equipped;
        ArrayList<ur> modulars = new ArrayList<ur>(5);
        for (ur stack : equipped = MuseItemUtils.itemsEquipped(player)) {
            if (stack == null || !(stack.b() instanceof IModularItem)) continue;
            modulars.add(stack);
        }
        return modulars;
    }

    public static ur[] itemsEquipped(qx player) {
        ur[] equipped = new ur[]{player.bJ.b[0], player.bJ.b[1], player.bJ.b[2], player.bJ.b[3], player.bJ.g()};
        return equipped;
    }

    public static boolean canStackTogether(ur stack1, ur stack2) {
        if (!MuseItemUtils.isSameItem(stack1, stack2)) {
            return false;
        }
        if (!stack1.e()) {
            return false;
        }
        return stack1.a < stack1.d();
    }

    public static boolean isSameItem(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.c != stack2.c) {
            return false;
        }
        return stack1.f() || stack1.j() == stack2.j();
    }

    public static void transferStackWithChance(ur itemsToGive, ur destinationStack, double chanceOfSuccess) {
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.lvcapacitor)) {
            itemsToGive.a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.mvcapacitor)) {
            itemsToGive.a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.hvcapacitor)) {
            itemsToGive.a = 0;
            return;
        }
        int maxSize = destinationStack.d();
        while (itemsToGive.a > 0 && destinationStack.a < maxSize) {
            --itemsToGive.a;
            if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
            ++destinationStack.a;
        }
    }

    public static Set giveOrDropItems(ur itemsToGive, qx player) {
        return MuseItemUtils.giveOrDropItemWithChance(itemsToGive, player, 1.0);
    }

    public static Set giveOrDropItemWithChance(ur itemsToGive, qx player, double chanceOfSuccess) {
        int i;
        HashSet<Integer> slots = new HashSet<Integer>();
        for (i = 0; i < player.bJ.k_() && itemsToGive.a > 0; ++i) {
            ur currentStack = player.bJ.a(i);
            if (!MuseItemUtils.canStackTogether(currentStack, itemsToGive)) continue;
            slots.add(i);
            MuseItemUtils.transferStackWithChance(itemsToGive, currentStack, chanceOfSuccess);
        }
        for (i = 0; i < player.bJ.k_() && itemsToGive.a > 0; ++i) {
            if (player.bJ.a(i) != null) continue;
            ur destination = new ur(itemsToGive.c, 0, itemsToGive.j());
            MuseItemUtils.transferStackWithChance(itemsToGive, destination, chanceOfSuccess);
            if (destination.a <= 0) continue;
            player.bJ.a(i, destination);
            slots.add(i);
        }
        if (itemsToGive.a > 0) {
            for (i = 0; i < itemsToGive.a; ++i) {
                if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
                ur copyStack = itemsToGive.l();
                copyStack.a = 1;
                player.c(copyStack);
            }
        }
        return slots;
    }

    public static double getPlayerWeight(qx player) {
        double weight = 0.0;
        for (ur stack : MuseItemUtils.modularItemsEquipped(player)) {
            weight += ModuleManager.computeModularProperty(stack, "Weight");
        }
        return weight;
    }

    public static List getPlayerInstalledModules(qx player) {
        ArrayList<IPowerModule> installedModules = new ArrayList<IPowerModule>();
        for (ur stack : MuseItemUtils.modularItemsEquipped(player)) {
            bq itemTag = MuseItemUtils.getMuseItemTag(stack);
            for (IPowerModule module : MuseItemUtils.getValidModulesForItem(player, stack)) {
                if (!MuseItemUtils.tagHasModule(itemTag, module.getName())) continue;
                installedModules.add(module);
            }
        }
        return installedModules;
    }

    public static void toggleModuleForPlayer(qx player, String name, boolean toggleval) {
        for (ur stack : MuseItemUtils.modularItemsEquipped(player)) {
            bq itemTag = MuseItemUtils.getMuseItemTag(stack);
            MuseItemUtils.toggleModule(itemTag, name, toggleval);
        }
    }

    public static boolean itemHasActiveModule(ur itemStack, String moduleName) {
        IPowerModule module = ModuleManager.getModule(moduleName);
        if (module == null || !module.isAllowed()) {
            return false;
        }
        if (module != null && module instanceof IRightClickModule) {
            return moduleName.equals(MuseItemUtils.getActiveMode(itemStack));
        }
        return MuseItemUtils.isModuleOnline(MuseItemUtils.getMuseItemTag(itemStack), moduleName);
    }

    public static String getActiveMode(ur itemStack) {
        return MuseItemUtils.getMuseItemTag(itemStack).i("Mode");
    }

    public static ur copyAndResize(ur stack, int number) {
        ur copy = stack.l();
        copy.a = number;
        return copy;
    }
}

