/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPlayerTickModule;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IRightClickModule;
import net.machinemuse.api.IToggleableModule;
import net.machinemuse.api.MuseItemUtils;

public class ModuleManager {
    protected static final Map moduleMap = new HashMap();
    protected static final List moduleList = new ArrayList();
    protected static final List playerTickModules = new ArrayList();
    protected static final List rightClickModules = new ArrayList();
    protected static final List toggleableModules = new ArrayList();

    public static List getAllModules() {
        return moduleList;
    }

    public static List getPlayerTickModules() {
        return playerTickModules;
    }

    public static IPowerModule getModule(String key) {
        return (IPowerModule)moduleMap.get(key);
    }

    public static void addModule(IPowerModule module) {
        moduleMap.put(module.getName(), module);
        moduleList.add(module);
        if (module instanceof IPlayerTickModule) {
            playerTickModules.add((IPlayerTickModule)module);
        }
        if (module instanceof IRightClickModule) {
            rightClickModules.add((IRightClickModule)module);
        }
        if (module instanceof IToggleableModule) {
            toggleableModules.add((IToggleableModule)module);
        }
    }

    public static double computeModularProperty(ur stack, String propertyName) {
        double propertyValue = 0.0;
        bq itemTag = MuseItemUtils.getMuseItemTag(stack);
        for (IPowerModule module : moduleList) {
            if (!MuseItemUtils.itemHasActiveModule(stack, module.getName())) continue;
            propertyValue = module.applyPropertyModifiers(itemTag, propertyName, propertyValue);
        }
        return propertyValue;
    }

    public static List getRightClickModules() {
        return rightClickModules;
    }

    public static List getToggleableModules() {
        return toggleableModules;
    }
}

