/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import icbm.api.explosion.IExplosive;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import universalelectricity.core.implement.IItemElectric;

public class ElectricItemUtils {
    public static final String MAXIMUM_ENERGY = "Maximum Energy";
    public static final String CURRENT_ENERGY = "Current Energy";

    public static double getPlayerEnergy(qx player) {
        double avail = 0.0;
        for (ur stack : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += ((IItemElectric)stack.b()).getJoules(stack);
        }
        return avail;
    }

    private static List electricItemsEquipped(qx player) {
        ur[] equipped;
        ArrayList<ur> electrics = new ArrayList<ur>(5);
        for (ur stack : equipped = MuseItemUtils.itemsEquipped(player)) {
            if (stack == null || !(stack.b() instanceof IItemElectric)) continue;
            electrics.add(stack);
        }
        return electrics;
    }

    public static void drainPlayerEnergy(qx player, double drainAmount) {
        for (ur stack : ElectricItemUtils.electricItemsEquipped(player)) {
            if (stack == null) continue;
            IItemElectric item = (IItemElectric)stack.b();
            Object[] objectArray = new Object[]{stack};
            double joules = item.getJoules(objectArray);
            if (joules > drainAmount) {
                item.onUse(drainAmount, stack);
                break;
            }
            drainAmount -= joules;
            item.onUse(joules, stack);
        }
    }

    public static double getMaxEnergy(qx player) {
        double max = 0.0;
        for (ur stack : ElectricItemUtils.electricItemsEquipped(player)) {
            max += ((IItemElectric)stack.b()).getMaxJoules(stack);
        }
        return max;
    }

    public static void givePlayerEnergy(qx player, double joulesToGive) {
        for (ur stack : ElectricItemUtils.electricItemsEquipped(player)) {
            if (stack == null) continue;
            IItemElectric item = (IItemElectric)stack.b();
            Object[] objectArray = new Object[]{stack};
            Object[] objectArray2 = new Object[]{stack};
            double missingjoules = item.getMaxJoules(objectArray) - item.getJoules(objectArray2);
            if (missingjoules > joulesToGive) {
                item.onUse(-joulesToGive, stack);
                break;
            }
            joulesToGive -= missingjoules;
            item.onUse(-missingjoules, stack);
        }
    }

    public static double charge(double amount, ur itemStack) {
        double stored = ElectricItemUtils.getJoules(itemStack);
        double capacity = ElectricItemUtils.getMaxJoules(itemStack) - stored;
        double taken = Math.min(amount, capacity);
        double surplus = amount - taken;
        ElectricItemUtils.setJoules(stored + taken, itemStack);
        return surplus;
    }

    public static double discharge(double joulesNeeded, ur itemStack) {
        bq itemProperties = MuseItemUtils.getMuseItemTag(itemStack);
        double joulesAvail = ElectricItemUtils.getJoules(itemStack);
        double joulesProvided = Math.min(joulesAvail, joulesNeeded);
        ElectricItemUtils.setJoules(joulesAvail - joulesProvided, itemStack);
        return joulesProvided;
    }

    public static double getJoules(ur stack) {
        double maxJoules;
        double joules = MuseItemUtils.getDoubleOrZero(stack, CURRENT_ENERGY);
        if (joules > (maxJoules = ElectricItemUtils.getMaxJoules(stack))) {
            joules = maxJoules;
            ElectricItemUtils.setJoules(joules, stack);
        }
        return joules;
    }

    public static void setJoules(double joules, ur stack) {
        MuseItemUtils.setDoubleOrRemove(stack, CURRENT_ENERGY, joules);
    }

    public static double getMaxJoules(ur stack) {
        double maxJoules = ModuleManager.computeModularProperty(stack, MAXIMUM_ENERGY);
        return maxJoules;
    }

    public static double getVoltage(ur itemStack) {
        return 120.0;
    }

    public static void onEMP(ur itemStack, lq entity, IExplosive empExplosive) {
        ElectricItemUtils.setJoules(0.0, itemStack);
    }
}

