/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import java.util.Random;

public class WorldGenBigAutumnTree
extends WorldGenAutumnTree {
    private static amq trunkBlock = amq.M;
    private static int trunkMetadata = 0;
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    private final Random rand = new Random();
    private yc world;
    private final int[] basePos = new int[]{0, 0, 0};
    private int heightLimit = 0;
    private int height;
    private final double heightAttenuation = 0.618;
    private final double branchSlope = 0.381;
    private double scaleWidth = 1.0;
    private double leafDensity = 1.0;
    private int heightLimitLimit = 12;
    private int leafDistanceLimit = 4;
    private int[][] leafNodes;

    public static void setTrunkBlock(amq block, int metadata) {
        trunkBlock = block;
        trunkMetadata = metadata;
    }

    public WorldGenBigAutumnTree(boolean notify, WorldGenAutumnTree.AutumnTreeType type) {
        super(notify, type);
    }

    private int checkBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger) {
        int var14;
        int[] var3 = new int[]{0, 0, 0};
        int var5 = 0;
        for (int var4 = 0; var4 < 3; var4 = (int)((byte)(var4 + 1))) {
            var3[var4] = par2ArrayOfInteger[var4] - par1ArrayOfInteger[var4];
            if (Math.abs(var3[var4]) <= Math.abs(var3[var5])) continue;
            var5 = var4;
        }
        if (var3[var5] == 0) {
            return -1;
        }
        byte var6 = otherCoordPairs[var5];
        byte var7 = otherCoordPairs[var5 + 3];
        int var8 = var3[var5] > 0 ? 1 : -1;
        double var9 = (double)var3[var6] / (double)var3[var5];
        double var11 = (double)var3[var7] / (double)var3[var5];
        int[] coord = new int[]{0, 0, 0};
        int var15 = var3[var5] + var8;
        for (var14 = 0; var14 != var15; var14 += var8) {
            coord[var5] = par1ArrayOfInteger[var5] + var14;
            coord[var6] = ke.c((double)((double)par1ArrayOfInteger[var6] + (double)var14 * var9));
            coord[var7] = ke.c((double)((double)par1ArrayOfInteger[var7] + (double)var14 * var11));
            int id = this.world.a(coord[0], coord[1], coord[2]);
            if (id != 0 && !amq.p[id].isLeaves(this.world, coord[0], coord[1], coord[2])) break;
        }
        return var14 == var15 ? -1 : Math.abs(var14);
    }

    @Override
    public boolean a(yc par1World, Random par2Random, int par3, int par4, int par5) {
        this.world = par1World;
        long var6 = par2Random.nextLong();
        this.rand.setSeed(var6);
        this.basePos[0] = par3;
        this.basePos[1] = par4;
        this.basePos[2] = par5;
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves(this.type.getID(), this.type.getMetadata());
        this.generateTrunk(WorldGenBigAutumnTree.trunkBlock.cm, trunkMetadata);
        this.generateLeafNodeBases(WorldGenBigAutumnTree.trunkBlock.cm, trunkMetadata);
        return true;
    }

    private void generateLeafNode(int x, int y, int z, int leafID, int leafMeta) {
        int heightLimit = y + this.leafDistanceLimit;
        for (int y1 = y; y1 < heightLimit; ++y1) {
            float size = this.leafSize(y1 - y);
            this.genTreeLayer(x, y1, z, size, (byte)1, leafID, leafMeta);
        }
    }

    private void generateLeafNodeBases(int woodID, int woodMeta) {
        int var2 = this.leafNodes.length;
        int[] var3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int var1 = 0; var1 < var2; ++var1) {
            int[] var4 = this.leafNodes[var1];
            int[] var5 = new int[]{var4[0], var4[1], var4[2]};
            var3[1] = var4[3];
            int var6 = var3[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(var6)) continue;
            this.placeBlockLine(var3, var5, woodID, woodMeta);
        }
    }

    private void generateLeafNodeList() {
        int var1;
        this.height = (int)((double)this.heightLimit * 0.618);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((var1 = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            var1 = 1;
        }
        int[][] var2 = new int[var1 * this.heightLimit][4];
        int var3 = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int var4 = 1;
        int var5 = this.basePos[1] + this.height;
        int var6 = var3 - this.basePos[1];
        var2[0][0] = this.basePos[0];
        var2[0][1] = var3--;
        var2[0][2] = this.basePos[2];
        var2[0][3] = var5;
        while (var6 >= 0) {
            float var8 = this.layerSize(var6);
            if (var8 < 0.0f) {
                --var3;
                --var6;
                continue;
            }
            double var9 = 0.5;
            for (int var7 = 0; var7 < var1; ++var7) {
                int[] var18;
                int var16;
                double var13;
                double var11 = this.scaleWidth * (double)var8 * ((double)this.rand.nextFloat() + 0.328);
                int var15 = ke.c((double)(var11 * Math.sin(var13 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + 0.5));
                int[] var17 = new int[]{var15, var3, var16 = ke.c((double)(var11 * Math.cos(var13) + (double)this.basePos[2] + 0.5))};
                if (this.checkBlockLine(var17, var18 = new int[]{var15, var3 + this.leafDistanceLimit, var16}) != -1) continue;
                int[] var19 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double var20 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - var17[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - var17[2]), 2.0));
                double var22 = var20 * 0.381;
                var19[1] = (double)var17[1] - var22 > (double)var5 ? var5 : (int)((double)var17[1] - var22);
                if (this.checkBlockLine(var19, var17) != -1) continue;
                var2[var4][0] = var15;
                var2[var4][1] = var3;
                var2[var4][2] = var16;
                var2[var4][3] = var19[1];
                ++var4;
            }
            --var3;
            --var6;
        }
        this.leafNodes = new int[var4][4];
        System.arraycopy(var2, 0, this.leafNodes, 0, var4);
    }

    private void generateLeaves(int leafID, int leafMeta) {
        int length = this.leafNodes.length;
        for (int node = 0; node < length; ++node) {
            this.generateLeafNode(this.leafNodes[node][0], this.leafNodes[node][1], this.leafNodes[node][2], leafID, leafMeta);
        }
    }

    private void generateTrunk(int woodID, int woodMeta) {
        int var1 = this.basePos[0];
        int var2 = this.basePos[1];
        int var3 = this.basePos[1] + this.height;
        int var4 = this.basePos[2];
        int[] var5 = new int[]{var1, var2, var4};
        int[] var6 = new int[]{var1, var3, var4};
        this.placeBlockLine(var5, var6, woodID, woodMeta);
    }

    private void genTreeLayer(int x, int y, int z, float size, byte par5, int leafBlockID, int leafBlockMeta) {
        int var7 = (int)((double)size + 0.618);
        byte var8 = otherCoordPairs[par5];
        byte var9 = otherCoordPairs[par5 + 3];
        int[] var10 = new int[]{x, y, z};
        int[] var11 = new int[]{0, 0, 0};
        int var13 = -var7;
        var11[par5] = var10[par5];
        for (int var12 = -var7; var12 <= var7; ++var12) {
            var11[var8] = var10[var8] + var12;
            var13 = -var7;
            while (var13 <= var7) {
                double var15 = Math.pow((double)Math.abs(var12) + 0.5, 2.0) + Math.pow((double)Math.abs(var13) + 0.5, 2.0);
                if (var15 > (double)(size * size)) {
                    ++var13;
                    continue;
                }
                var11[var9] = var10[var9] + var13;
                int blockID = this.world.a(var11[0], var11[1], var11[2]);
                if (blockID != 0 && !amq.p[blockID].isLeaves(this.world, var11[0], var11[1], var11[2])) {
                    ++var13;
                    continue;
                }
                if (blockID == 0 || amq.p[blockID].canBeReplacedByLeaves(this.world, var11[0], var11[1], var11[2])) {
                    this.a(this.world, var11[0], var11[1], var11[2], leafBlockID, leafBlockMeta);
                }
                ++var13;
            }
        }
    }

    private float layerSize(int par1) {
        if ((double)par1 < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float var2 = (float)this.heightLimit / 2.0f;
        float var3 = (float)this.heightLimit / 2.0f - (float)par1;
        float var4 = var3 == 0.0f ? var2 : (Math.abs(var3) >= var2 ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(var2), 2.0) - Math.pow(Math.abs(var3), 2.0)));
        return var4 *= 0.5f;
    }

    private boolean leafNodeNeedsBase(int par1) {
        return (double)par1 >= (double)this.heightLimit * 0.2;
    }

    float leafSize(int par1) {
        return par1 >= 0 && par1 < this.leafDistanceLimit ? (par1 != 0 && par1 != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    private void placeBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger, int woodID, int woodMeta) {
        int[] var4 = new int[]{0, 0, 0};
        int var6 = 0;
        for (int var5 = 0; var5 < 3; var5 = (int)((byte)(var5 + 1))) {
            var4[var5] = par2ArrayOfInteger[var5] - par1ArrayOfInteger[var5];
            if (Math.abs(var4[var5]) <= Math.abs(var4[var6])) continue;
            var6 = var5;
        }
        if (var4[var6] != 0) {
            byte var7 = otherCoordPairs[var6];
            byte var8 = otherCoordPairs[var6 + 3];
            int var9 = var4[var6] > 0 ? 1 : -1;
            double var10 = (double)var4[var7] / (double)var4[var6];
            double var12 = (double)var4[var8] / (double)var4[var6];
            int[] var14 = new int[]{0, 0, 0};
            int var16 = var4[var6] + var9;
            for (int var15 = 0; var15 != var16; var15 += var9) {
                int var19;
                var14[var6] = ke.c((double)((double)(par1ArrayOfInteger[var6] + var15) + 0.5));
                var14[var7] = ke.c((double)((double)par1ArrayOfInteger[var7] + (double)var15 * var10 + 0.5));
                var14[var8] = ke.c((double)((double)par1ArrayOfInteger[var8] + (double)var15 * var12 + 0.5));
                byte woodMetaWithDirection = (byte)woodMeta;
                int var18 = Math.abs(var14[0] - par1ArrayOfInteger[0]);
                int var20 = Math.max(var18, var19 = Math.abs(var14[2] - par1ArrayOfInteger[2]));
                if (var20 > 0) {
                    if (var18 == var20) {
                        woodMetaWithDirection = (byte)(woodMetaWithDirection | 4);
                    } else if (var19 == var20) {
                        woodMetaWithDirection = (byte)(woodMetaWithDirection | 8);
                    }
                }
                this.a(this.world, var14[0], var14[1], var14[2], woodID, woodMetaWithDirection);
            }
        }
    }

    public void a(double par1, double par3, double par5) {
        this.heightLimitLimit = (int)(par1 * 12.0);
        if (par1 > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = par3;
        this.leafDensity = par5;
    }

    private boolean validTreeLocation() {
        int[] var1 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] var2 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        int var3 = this.world.a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        if (var3 != 2 && var3 != 3) {
            return false;
        }
        int var4 = this.checkBlockLine(var1, var2);
        if (var4 == -1) {
            return true;
        }
        if (var4 < 6) {
            return false;
        }
        this.heightLimit = var4;
        return true;
    }
}

