/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.biome;

import extrabiomes.lib.DecorationSettings;
import java.util.Map;

class CustomBiomeDecorator
extends zc {
    private CustomBiomeDecorator() {
        super(null);
    }

    private CustomBiomeDecorator(Builder builder) {
        super(builder.biome);
        this.y = builder.waterlilyPerChunk;
        this.z = builder.treesPerChunk;
        this.A = builder.flowersPerChunk;
        this.B = builder.grassPerChunk;
        this.C = builder.deadBushPerChunk;
        this.D = builder.mushroomsPerChunk;
        this.E = builder.reedsPerChunk;
        this.F = builder.cactiPerChunk;
        this.G = builder.sandPerChunk;
        this.H = builder.sandPerChunk2;
        this.I = builder.clayPerChunk;
        this.J = builder.bigMushroomsPerChunk;
    }

    static class Builder {
        private final yy biome;
        private int waterlilyPerChunk = 0;
        private int treesPerChunk = 0;
        private int flowersPerChunk = 2;
        private int grassPerChunk = 1;
        private int deadBushPerChunk = 0;
        private int mushroomsPerChunk = 0;
        private int reedsPerChunk = 0;
        private int cactiPerChunk = 0;
        private int sandPerChunk = 1;
        private int sandPerChunk2 = 3;
        private int clayPerChunk = 1;
        private int bigMushroomsPerChunk = 0;

        Builder(yy biome) {
            this.biome = biome;
        }

        Builder loadSettings(DecorationSettings dec) {
            Map settings = dec.getSettings();
            if (settings.containsKey((Object)DecorationSettings.Decoration.BIGMUSHROOMS)) {
                this.bigMushroomsPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.BIGMUSHROOMS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.CACTI)) {
                this.cactiPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.CACTI));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.CLAY)) {
                this.clayPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.CLAY));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.DEADBUSH)) {
                this.deadBushPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.DEADBUSH));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.FLOWERS)) {
                this.flowersPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.FLOWERS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.GRASS)) {
                this.grassPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.GRASS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.MUSHROOMS)) {
                this.mushroomsPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.MUSHROOMS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.REEDS)) {
                this.reedsPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.REEDS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.SAND) && settings.containsKey((Object)DecorationSettings.Decoration.SAND2)) {
                this.sandPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.SAND), (Integer)settings.get((Object)DecorationSettings.Decoration.SAND2));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.TREES)) {
                this.treesPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.TREES));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.WATERLILY)) {
                this.waterlilyPerChunk((Integer)settings.get((Object)DecorationSettings.Decoration.WATERLILY));
            }
            return this;
        }

        Builder bigMushroomsPerChunk(int val) {
            this.bigMushroomsPerChunk = val;
            return this;
        }

        CustomBiomeDecorator build() {
            return new CustomBiomeDecorator(this);
        }

        Builder cactiPerChunk(int val) {
            this.cactiPerChunk = val;
            return this;
        }

        Builder clayPerChunk(int val) {
            this.clayPerChunk = val;
            return this;
        }

        Builder deadBushPerChunk(int val) {
            this.deadBushPerChunk = val;
            return this;
        }

        Builder flowersPerChunk(int val) {
            this.flowersPerChunk = val;
            return this;
        }

        Builder grassPerChunk(int val) {
            this.grassPerChunk = val;
            return this;
        }

        Builder mushroomsPerChunk(int val) {
            this.mushroomsPerChunk = val;
            return this;
        }

        Builder reedsPerChunk(int val) {
            this.reedsPerChunk = val;
            return this;
        }

        Builder sandPerChunk(int val, int val2) {
            this.sandPerChunk = val;
            this.sandPerChunk2 = val2;
            return this;
        }

        Builder treesPerChunk(int val) {
            this.treesPerChunk = val;
            return this;
        }

        Builder waterlilyPerChunk(int val) {
            this.waterlilyPerChunk = val;
            return this;
        }
    }
}

