/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Random;

@Deprecated
public abstract class BiomeManager {
    public static Optional alpine = Optional.absent();
    public static Optional autumnwoods = Optional.absent();
    public static Optional birchforest = Optional.absent();
    public static Optional extremejungle = Optional.absent();
    public static Optional forestedisland = Optional.absent();
    public static Optional forestedhills = Optional.absent();
    public static Optional glacier = Optional.absent();
    public static Optional greenhills = Optional.absent();
    public static Optional icewasteland = Optional.absent();
    public static Optional greenswamp = Optional.absent();
    public static Optional marsh = Optional.absent();
    public static Optional meadow = Optional.absent();
    public static Optional minijungle = Optional.absent();
    public static Optional mountaindesert = Optional.absent();
    public static Optional mountainridge = Optional.absent();
    public static Optional mountaintaiga = Optional.absent();
    public static Optional pineforest = Optional.absent();
    public static Optional rainforest = Optional.absent();
    public static Optional redwoodforest = Optional.absent();
    public static Optional redwoodlush = Optional.absent();
    public static Optional savanna = Optional.absent();
    public static Optional shrubland = Optional.absent();
    public static Optional snowforest = Optional.absent();
    public static Optional snowyrainforest = Optional.absent();
    public static Optional temperaterainforest = Optional.absent();
    public static Optional tundra = Optional.absent();
    public static Optional wasteland = Optional.absent();
    public static Optional woodlands = Optional.absent();
    protected static Optional instance = Optional.absent();

    public static void addWeightedGrassGenForBiome(yy biome, abm grassGen, int weight) {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Cannot add weighted grass gens until after API is initialized.");
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        Preconditions.checkNotNull((Object)grassGen, (Object)"Grass generator is required.");
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than zero.");
        ((BiomeManager)instance.get()).addBiomeGen(GenType.GRASS, biome, grassGen, weight);
    }

    public static void addWeightedTreeGenForBiome(yy biome, abm treeGen, int weight) {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Cannot add weighted tree gens until after API is initialized.");
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        Preconditions.checkNotNull((Object)treeGen, (Object)"Tree Generator is required.");
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than zero.");
        ((BiomeManager)instance.get()).addBiomeGen(GenType.TREE, biome, treeGen, weight);
    }

    public static Optional chooseRandomGrassGenforBiome(Random rand, yy biome) {
        return ((BiomeManager)instance.get()).chooseBiomeRandomGen(GenType.GRASS, rand, biome);
    }

    public static Optional chooseRandomTreeGenforBiome(Random rand, yy biome) {
        return ((BiomeManager)instance.get()).chooseBiomeRandomGen(GenType.TREE, rand, biome);
    }

    public static Collection getBiomes() {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Biome list not available until after API is initialized.");
        return ((BiomeManager)instance.get()).getBiomeCollection();
    }

    public static int getTotalGrassWeightForBiome(yy biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        return ((BiomeManager)instance.get()).getBiomeTotalWeight(GenType.GRASS, biome);
    }

    public static int getTotalTreeWeightForBiome(yy biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        return ((BiomeManager)instance.get()).getBiomeTotalWeight(GenType.TREE, biome);
    }

    static boolean isActive() {
        return instance.isPresent();
    }

    protected abstract void addBiomeGen(GenType var1, yy var2, abm var3, int var4);

    protected abstract Optional chooseBiomeRandomGen(GenType var1, Random var2, yy var3);

    protected abstract Collection getBiomeCollection();

    protected abstract int getBiomeTotalWeight(GenType var1, yy var2);

    protected static enum GenType {
        TREE,
        GRASS;

    }
}

