/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.flag.Flag;
import universalelectricity.prefab.flag.FlagBase;
import universalelectricity.prefab.flag.FlagWorld;
import universalelectricity.prefab.vector.Region3;

public class FlagRegion
extends FlagBase {
    public FlagWorld flagWorld;
    public String name;
    public Region3 region;
    private final List flags = new ArrayList();

    public FlagRegion(FlagWorld worldFlagData) {
        this.flagWorld = worldFlagData;
    }

    public FlagRegion(FlagWorld flagWorld, String name, Region3 region) {
        this.flagWorld = flagWorld;
        this.name = name;
        this.region = region;
    }

    @Override
    public void readFromNBT(bq nbt) {
        this.name = nbt.e();
        Vector3 startVector = Vector3.readFromNBT("min_", nbt);
        Vector3 endVector = Vector3.readFromNBT("max_", nbt);
        this.region = new Region3(startVector, endVector);
        by flagList = nbt.m("flags");
        for (int i = 0; i < flagList.c(); ++i) {
            bq childNode = (bq)flagList.b(i);
            try {
                Flag flag = new Flag(this);
                flag.readFromNBT(childNode);
                this.flags.add(flag);
                continue;
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to read flag data: " + childNode.e());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(bq nbt) {
        nbt.p(this.name);
        this.region.min.writeToNBT("min_", nbt);
        this.region.max.writeToNBT("max_", nbt);
        by flagList = new by();
        for (Flag flag : this.getFlags()) {
            try {
                flagList.a((cd)flag.getNBT());
            }
            catch (Exception e) {
                System.out.println("Failed to save world flag data: " + flag.name);
                e.printStackTrace();
            }
        }
        nbt.a("flags", (cd)flagList);
    }

    public boolean containsValue(String flagName, String checkValue, Vector3 position) {
        for (Flag flag : this.flags) {
            if (!flag.name.equalsIgnoreCase(flagName) || !flag.value.equalsIgnoreCase(checkValue)) continue;
            return true;
        }
        return false;
    }

    public boolean setFlag(String flagName, String value) {
        this.removeFlag(flagName);
        if (value != null && value != "" && !this.containsFlag(flagName)) {
            return this.flags.add(new Flag(this, flagName, value));
        }
        return false;
    }

    public boolean containsFlag(String flagName) {
        for (Flag region : this.flags) {
            if (!region.name.equalsIgnoreCase(flagName)) continue;
            return true;
        }
        return false;
    }

    public boolean removeFlag(String flagName) {
        for (Flag region : this.flags) {
            if (!region.name.equalsIgnoreCase(flagName)) continue;
            this.flags.remove(region);
            return true;
        }
        return false;
    }

    public List getFlags() {
        Iterator it2 = this.flags.iterator();
        while (it2.hasNext()) {
            Flag flag = (Flag)it2.next();
            if (flag == null) {
                it2.remove();
                continue;
            }
            if (flag.name != null && flag.name != "") continue;
            it2.remove();
        }
        return this.flags;
    }

    public void edit(Vector3 position, int radius) {
        Vector3 minVec = new Vector3(position.intX() - radius, 0, position.intZ() - radius);
        Vector3 maxVec = new Vector3(position.intX() + radius, this.flagWorld.world.O(), position.intZ() + radius);
        this.region = new Region3(minVec, maxVec);
    }
}

