/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;

public abstract class TileEntityLiquidFabricator
extends TileEntityFactoryPowered
implements ITankContainer {
    private int _liquidId;
    private int _liquidFabPerTick;
    private LiquidTank _tank;

    protected TileEntityLiquidFabricator(int liquidId, int liquidCostPermB, int liquidFabPerTick) {
        super(liquidCostPermB * liquidFabPerTick);
        this._liquidId = liquidId;
        this._liquidFabPerTick = liquidFabPerTick;
        this._tank = new LiquidTank(1000);
    }

    @Override
    protected boolean activateMachine() {
        if (this._liquidId < 0) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        if (this._tank.getLiquid() != null && this._tank.getCapacity() - this._tank.getLiquid().amount < this._liquidFabPerTick) {
            return false;
        }
        this._tank.fill(new LiquidStack(this._liquidId, this._liquidFabPerTick), true);
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 0;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int k_() {
        return 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this._tank;
    }
}

