/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryInventory;
import powercrystals.minefactoryreloaded.transport.RemoteInventoryCrafting;

public class TileEntityLiquiCrafter
extends TileEntityFactoryInventory
implements ISidedInventory,
ITankContainer {
    private boolean _lastRedstoneState;
    private LiquidTank[] _tanks = new LiquidTank[9];

    public TileEntityLiquiCrafter() {
        for (int i = 0; i < 9; ++i) {
            this._tanks[i] = new LiquidTank(10000);
        }
    }

    @Override
    public String getGuiBackground() {
        return "liquicrafter.png";
    }

    @Override
    public void g() {
        super.g();
        boolean redstoneState = Util.isRedstonePowered((any)this);
        if (redstoneState && !this._lastRedstoneState && !this.k.I && this._inventory[9] != null && (this._inventory[10] == null || this._inventory[10].a + this._inventory[9].a <= this._inventory[9].d() && this._inventory[9].c == this._inventory[10].c && this._inventory[9].j() == this._inventory[10].j())) {
            this.checkResources();
        }
        this._lastRedstoneState = redstoneState;
    }

    private void checkResources() {
        int i;
        LiquidStack l;
        int i2;
        LinkedList<ItemResourceTracker> requiredItems = new LinkedList<ItemResourceTracker>();
        block0: for (i2 = 0; i2 < 9; ++i2) {
            if (this._inventory[i2] == null) continue;
            if (LiquidContainerRegistry.isFilledContainer((ur)this._inventory[i2])) {
                l = LiquidContainerRegistry.getLiquidForFilledItem((ur)this._inventory[i2]);
                for (ItemResourceTracker t : requiredItems) {
                    if (t.id != l.itemID || t.meta != l.itemMeta) continue;
                    t.required += 1000;
                    continue block0;
                }
                requiredItems.add(new ItemResourceTracker(l.itemID, l.itemMeta, 1000));
                continue;
            }
            for (ItemResourceTracker t : requiredItems) {
                if (t.id != this._inventory[i2].c || t.meta != this._inventory[i2].j()) continue;
                ++t.required;
                continue block0;
            }
            requiredItems.add(new ItemResourceTracker(this._inventory[i2].c, this._inventory[i2].j(), 1));
        }
        block3: for (i2 = 11; i2 < 29; ++i2) {
            if (this._inventory[i2] == null) continue;
            for (ItemResourceTracker t : requiredItems) {
                if (t.id != this._inventory[i2].c || t.meta != this._inventory[i2].j() && !this._inventory[i2].b().n()) continue;
                if (!this._inventory[i2].b().s()) {
                    t.found += this._inventory[i2].a;
                    continue block3;
                }
                ++t.found;
                continue block3;
            }
        }
        block5: for (i2 = 0; i2 < this._tanks.length; ++i2) {
            l = this._tanks[i2].getLiquid();
            if (l == null || l.amount == 0) continue;
            for (ItemResourceTracker t : requiredItems) {
                if (t.id != l.itemID || t.meta != l.itemMeta) continue;
                t.found += l.amount;
                continue block5;
            }
        }
        for (ItemResourceTracker t : requiredItems) {
            if (t.found >= t.required) continue;
            return;
        }
        block8: for (i = 11; i < 29; ++i) {
            if (this._inventory[i] == null) continue;
            for (ItemResourceTracker t : requiredItems) {
                int use;
                if (t.id != this._inventory[i].c || t.meta != this._inventory[i].j() && !this._inventory[i].b().n()) continue;
                if (this._inventory[i].b().s()) {
                    use = 1;
                    ur container = this._inventory[i].b().getContainerItemStack(this._inventory[i]);
                    this._inventory[i] = container.f() && container.j() > container.k() ? null : container;
                } else {
                    use = Math.min(t.required, this._inventory[i].a);
                    this._inventory[i].a -= use;
                }
                t.required -= use;
                if (this._inventory[i].a == 0) {
                    this._inventory[i] = null;
                }
                if (t.required != 0) continue block8;
                requiredItems.remove(t);
                continue block8;
            }
        }
        block10: for (i = 0; i < this._tanks.length; ++i) {
            l = this._tanks[i].getLiquid();
            if (l == null || l.amount == 0) continue;
            for (ItemResourceTracker t : requiredItems) {
                if (t.id != l.itemID || t.meta != l.itemMeta) continue;
                int use = Math.min(t.required, l.amount);
                this._tanks[i].drain(use, true);
                t.required -= use;
                if (t.required != 0) continue block10;
                requiredItems.remove(t);
                continue block10;
            }
        }
        if (this._inventory[10] == null) {
            this._inventory[10] = this._inventory[9].l();
            this._inventory[10].a = this._inventory[9].a;
        } else {
            this._inventory[10].a += this._inventory[9].a;
        }
    }

    private void calculateOutput() {
        this._inventory[9] = this.findMatchingRecipe();
    }

    public int k_() {
        return 29;
    }

    @Override
    public void a(int slot, ur stack) {
        this._inventory[slot] = stack;
        if (slot < 9) {
            this.calculateOutput();
        }
    }

    public String b() {
        return "LiquiCrafter";
    }

    @Override
    public int c() {
        return 64;
    }

    @Override
    public boolean a_(qx player) {
        return player.e((double)this.l, (double)this.m, (double)this.n) <= 64.0;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 10;
        }
        return 11;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 1;
        }
        return 18;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int match = this.findFirstMatchingTank(resource);
        if (match >= 0) {
            return this._tanks[match].fill(resource, doFill);
        }
        match = this.findFirstEmptyTank();
        if (match >= 0) {
            return this._tanks[match].fill(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int match = this.findFirstMatchingTank(resource);
        if (match >= 0) {
            return this._tanks[match].fill(resource, doFill);
        }
        match = this.findFirstEmptyTank();
        if (match >= 0) {
            return this._tanks[match].fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int match = this.findFirstNonEmptyTank();
        if (match >= 0) {
            return this._tanks[match].drain(maxDrain, doDrain);
        }
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this._tanks[tankIndex].drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this._tanks;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        int match = this.findFirstMatchingTank(type);
        if (match >= 0) {
            return this._tanks[match];
        }
        match = this.findFirstEmptyTank();
        if (match >= 0) {
            return this._tanks[match];
        }
        return null;
    }

    private int findFirstEmptyTank() {
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getLiquid() != null && this._tanks[i].getLiquid().amount != 0) continue;
            return i;
        }
        return -1;
    }

    private int findFirstNonEmptyTank() {
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getLiquid() == null || this._tanks[i].getLiquid().amount <= 0) continue;
            return i;
        }
        return -1;
    }

    private int findFirstMatchingTank(LiquidStack liquid) {
        if (liquid == null) {
            return -1;
        }
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getLiquid() == null || this._tanks[i].getLiquid().itemID != liquid.itemID || this._tanks[i].getLiquid().itemMeta != liquid.itemMeta) continue;
            return i;
        }
        return -1;
    }

    private ur findMatchingRecipe() {
        RemoteInventoryCrafting craft = new RemoteInventoryCrafting();
        for (int i = 0; i < 9; ++i) {
            craft.a(i, this._inventory[i] == null ? null : this._inventory[i].l());
        }
        return wn.a().a((ry)craft, this.k);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        by nbttaglist = nbttagcompound.m("Tanks");
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            int j = nbttagcompound1.c("Tank") & 0xFF;
            if (j < 0 || j >= this._tanks.length) continue;
            LiquidStack l = new LiquidStack(0, 0, 0);
            l.readFromNBT(nbttagcompound1);
            this._tanks[j].setLiquid(l);
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        by tanks = new by();
        for (int i = 0; i < this._tanks.length; ++i) {
            if (this._tanks[i].getLiquid() == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Tank", (byte)i);
            LiquidStack l = this._tanks[i].getLiquid();
            l.writeToNBT(nbttagcompound1);
            tanks.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Tanks", (cd)tanks);
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    private class ItemResourceTracker {
        public int id;
        public int meta;
        public int required;
        public int found;

        public ItemResourceTracker(int id, int meta, int required) {
            this.id = id;
            this.meta = meta;
            this.required = required;
        }
    }
}

