/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;

public class TileEntityComposter
extends TileEntityFactoryPowered
implements ITankContainer {
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityComposter() {
        super(20);
    }

    @Override
    public String getGuiBackground() {
        return "composter.png";
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean activateMachine() {
        if (this._tank.getLiquid() != null && this._tank.getLiquid().amount > 20) {
            this._tank.drain(20, true);
            this.setWorkDone(this.getWorkDone() + 20);
            if (this.getWorkDone() >= this.getWorkMax()) {
                MFRUtil.dropStack(this, new ur(MineFactoryReloadedCore.fertilizerItem));
                this.setWorkDone(0);
            }
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 8000;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != MineFactoryReloadedCore.sewageItem.cj) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != MineFactoryReloadedCore.sewageItem.cj) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (type != null && type.itemID == MineFactoryReloadedCore.sewageItem.cj) {
            return this._tank;
        }
        return null;
    }

    @Override
    public String b() {
        return "Composter";
    }

    public int k_() {
        return 0;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }
}

