/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.AutoEnchantmentHelper;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;

public class TileEntityAutoEnchanter
extends TileEntityFactoryPowered
implements ISidedInventory,
ITankContainer {
    private Random _rand = new Random();
    private int _targetLevel = 30;
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityAutoEnchanter() {
        super(160);
    }

    @Override
    public String getGuiBackground() {
        return "autoenchanter.png";
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    @Override
    public int getWorkMax() {
        return this._targetLevel + (int)(Math.pow((double)this._targetLevel / 7.5, 4.0) * 10.0 * this.getEnchantmentMultiplier());
    }

    private double getEnchantmentMultiplier() {
        ur s2 = this.a(0);
        if (s2 == null) {
            return 1.0;
        }
        Map enchantments = AutoEnchantmentHelper.a((ur)s2);
        if (enchantments == null || enchantments.size() == 0) {
            return 1.0;
        }
        return Math.pow((double)enchantments.size() + 1.0, 2.0);
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    public int getTargetLevel() {
        return this._targetLevel;
    }

    public void setTargetLevel(int targetLevel) {
        this._targetLevel = targetLevel;
        if (this._targetLevel > 30) {
            this._targetLevel = 30;
        }
        if (this._targetLevel < 1) {
            this._targetLevel = 1;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            this.activateMachine();
        }
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean activateMachine() {
        ur s2 = this.a(0);
        if (s2 == null) {
            this.setWorkDone(0);
            return false;
        }
        if (s2.b().c() == 0 || s2.c == up.bW.cj) {
            this.a(0, null);
            this.a(1, s2);
            this.setWorkDone(0);
            return true;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            AutoEnchantmentHelper.addRandomEnchantment(this._rand, s2, this._targetLevel);
            this.a(0, null);
            this.a(1, s2);
            this.setWorkDone(0);
            return true;
        }
        if (this._tank.getLiquid() != null && this._tank.getLiquid().amount >= 4) {
            this._tank.drain(4, true);
            this.setWorkDone(this.getWorkDone() + 1);
            return true;
        }
        return false;
    }

    @Override
    public String b() {
        return "Enchanter";
    }

    public int k_() {
        return 2;
    }

    @Override
    public int c() {
        return MineFactoryReloadedCore.enableCompatibleAutoEnchanter.getBoolean(false) ? 64 : 1;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 0;
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 1;
        }
        return 1;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetLevel", this._targetLevel);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this._targetLevel = nbttagcompound.e("targetLevel");
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != MineFactoryReloadedCore.mobEssenceItem.cj) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != MineFactoryReloadedCore.mobEssenceItem.cj) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (type != null && type.itemID == MineFactoryReloadedCore.mobEssenceItem.cj) {
            return this._tank;
        }
        return null;
    }
}

