/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.power;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.power.TileEntityGenerator;

public abstract class TileEntityLiquidGenerator
extends TileEntityGenerator
implements ITankContainer {
    private int _liquidConsumedPerTick;
    private int _powerProducedPerConsumption;
    private int _ticksBetweenConsumption;
    private int _outputPulseSize;
    private int _ticksSinceLastConsumption = 0;
    private int _bufferMax = 1000;
    private int _buffer;
    private LiquidTank _tank;

    public TileEntityLiquidGenerator(int liquidConsumedPerTick, int powerProducedPerConsumption, int ticksBetweenConsumption) {
        this._liquidConsumedPerTick = liquidConsumedPerTick;
        this._powerProducedPerConsumption = powerProducedPerConsumption;
        this._ticksBetweenConsumption = ticksBetweenConsumption;
        this._outputPulseSize = 100;
        this._tank = new LiquidTank(4000);
    }

    protected abstract LiquidStack getLiquidType();

    public int getBuffer() {
        return this._buffer;
    }

    public void setBuffer(int buffer) {
        this._buffer = buffer;
    }

    public int getBufferMax() {
        return this._bufferMax;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public void g() {
        super.g();
        if (!this.k.I) {
            this.setIsActive(this._buffer > this._outputPulseSize * 2);
            int mjPulse = Math.min(this._buffer, this._outputPulseSize);
            this._buffer -= mjPulse;
            this._buffer += this.producePower(mjPulse);
            if (this._ticksSinceLastConsumption < this._ticksBetweenConsumption) {
                ++this._ticksSinceLastConsumption;
                return;
            }
            this._ticksSinceLastConsumption = 0;
            if (Util.isRedstonePowered((any)this)) {
                return;
            }
            if (this._tank.getLiquid() == null || this._tank.getLiquid().amount < this._liquidConsumedPerTick || this._bufferMax - this._buffer < this._powerProducedPerConsumption) {
                return;
            }
            this._tank.drain(this._liquidConsumedPerTick, true);
            this._buffer += this._powerProducedPerConsumption;
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != this.getLiquidType().itemID || resource.itemMeta != this.getLiquidType().itemMeta) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this._tank;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("ticksSinceLastConsumption", this._ticksSinceLastConsumption);
        nbttagcompound.a("buffer", this._buffer);
        if (this._tank.getLiquid() != null) {
            nbttagcompound.a("tankAmount", this._tank.getLiquid().amount);
            nbttagcompound.a("tankItemId", this._tank.getLiquid().itemID);
            nbttagcompound.a("tankMeta", this._tank.getLiquid().itemMeta);
        }
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this._ticksSinceLastConsumption = nbttagcompound.e("ticksSinceLastConsumption");
        this._buffer = nbttagcompound.e("buffer");
        this._tank.setLiquid(new LiquidStack(nbttagcompound.e("tankItemId"), nbttagcompound.e("tankAmount"), nbttagcompound.e("tankItemMeta")));
        if (this._tank.getLiquid() != null && this._tank.getLiquid().amount > this._tank.getCapacity()) {
            this._tank.getLiquid().amount = this._tank.getCapacity();
        }
    }
}

