/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.plants;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;
import powercrystals.minefactoryreloaded.plants.TreeHarvestManager;

public class TileEntityHarvester
extends TileEntityFactoryPowered
implements ITankContainer,
ISidedInventory {
    private static Map harvestables = new HashMap();
    private HashMap _settings;
    private Random _rand;
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);
    private TreeHarvestManager _treeManager;
    private BlockPosition _lastTree;
    private LiquidTank _tank = new LiquidTank(4000);

    public static void registerHarvestable(IFactoryHarvestable harvestable) {
        harvestables.put(harvestable.getSourceId(), harvestable);
    }

    public TileEntityHarvester() {
        super(240);
        this._settings = new HashMap();
        this._settings.put("silkTouch", false);
        this._settings.put("harvestSmallMushrooms", false);
        this._settings.put("harvestJungleWood", false);
        this._rand = new Random();
    }

    @Override
    public String getGuiBackground() {
        return "harvester.png";
    }

    public HashMap getSettings() {
        return this._settings;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public boolean activateMachine() {
        MFRUtil.pumpLiquid((ILiquidTank)this._tank, this);
        int harvestedBlockId = 0;
        int harvestedBlockMetadata = 0;
        BlockPosition targetCoords = this.getNextHarvest();
        if (targetCoords == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        harvestedBlockId = this.k.a(targetCoords.x, targetCoords.y, targetCoords.z);
        harvestedBlockMetadata = this.k.h(targetCoords.x, targetCoords.y, targetCoords.z);
        IFactoryHarvestable harvestable = (IFactoryHarvestable)harvestables.get(new Integer(harvestedBlockId));
        List drops = harvestable.getDrops(this.k, this._rand, (Map)ImmutableMap.copyOf((Map)this._settings), targetCoords.x, targetCoords.y, targetCoords.z);
        harvestable.preHarvest(this.k, targetCoords.x, targetCoords.y, targetCoords.z);
        if (drops != null) {
            for (ur dropStack : drops) {
                MFRUtil.dropStack(this, dropStack);
            }
        }
        if (harvestable.breakBlock()) {
            if (MineFactoryReloadedCore.playSounds.getBoolean(true)) {
                this.k.a(null, 2001, targetCoords.x, targetCoords.y, targetCoords.z, harvestedBlockId + (harvestedBlockMetadata << 12));
            }
            this.k.e(targetCoords.x, targetCoords.y, targetCoords.z, 0);
        }
        harvestable.postHarvest(this.k, targetCoords.x, targetCoords.y, targetCoords.z);
        this._tank.fill(new LiquidStack(MineFactoryReloadedCore.sludgeItem, 10), true);
        return true;
    }

    private BlockPosition getNextHarvest() {
        BlockPosition bp = this._areaManager.getNextBlock();
        int searchId = this.k.a(bp.x, bp.y, bp.z);
        if (!harvestables.containsKey(new Integer(searchId))) {
            this._lastTree = null;
            return null;
        }
        IFactoryHarvestable harvestable = (IFactoryHarvestable)harvestables.get(new Integer(searchId));
        if (harvestable.canBeHarvested(this.k, this._settings, bp.x, bp.y, bp.z)) {
            if (harvestable.getHarvestType() == HarvestType.Normal) {
                this._lastTree = null;
                return bp;
            }
            if (harvestable.getHarvestType() == HarvestType.LeaveBottom) {
                this._lastTree = null;
                return this.getNextVertical(bp.x, bp.y, bp.z);
            }
            if (harvestable.getHarvestType() == HarvestType.Tree) {
                BlockPosition temp = this.getNextTreeSegment(bp.x, bp.y, bp.z);
                if (temp != null) {
                    this._areaManager.rewindBlock();
                }
                return temp;
            }
        }
        this._lastTree = null;
        return null;
    }

    private BlockPosition getNextVertical(int x, int y, int z) {
        int blockId;
        int highestBlockOffset = -1;
        int currentYoffset = 1;
        while (currentYoffset < MineFactoryReloadedCore.verticalHarvestSearchMaxVertical.getInt() && harvestables.containsKey(new Integer(blockId = this.k.a(x, y + currentYoffset, z))) && ((IFactoryHarvestable)harvestables.get(new Integer(blockId))).canBeHarvested(this.k, this._settings, x, y + currentYoffset, z)) {
            highestBlockOffset = currentYoffset++;
        }
        if (highestBlockOffset < 0) {
            return null;
        }
        return new BlockPosition(x, y + highestBlockOffset, z);
    }

    private BlockPosition getNextTreeSegment(int x, int y, int z) {
        if (this._lastTree == null || this._lastTree.x != x || this._lastTree.y != y || this._lastTree.z != z) {
            Area a = new Area(x - MineFactoryReloadedCore.treeSearchMaxHorizontal.getInt(), x + MineFactoryReloadedCore.treeSearchMaxHorizontal.getInt(), y, y + MineFactoryReloadedCore.treeSearchMaxVertical.getInt(), z - MineFactoryReloadedCore.treeSearchMaxHorizontal.getInt(), z + MineFactoryReloadedCore.treeSearchMaxHorizontal.getInt());
            this._treeManager = new TreeHarvestManager(a);
            this._lastTree = new BlockPosition(x, y, z);
        } else if (this._treeManager.getIsDone()) {
            this._treeManager.reset();
        }
        while (!this._treeManager.getIsDone()) {
            BlockPosition bp = this._treeManager.getNextBlock();
            int blockId = this.k.a(bp.x, bp.y, bp.z);
            if (harvestables.containsKey(new Integer(blockId)) && ((IFactoryHarvestable)harvestables.get(new Integer(blockId))).canBeHarvested(this.k, this._settings, bp.x, bp.y, bp.z)) {
                if (this._treeManager.getIsLeafPass() && ((IFactoryHarvestable)harvestables.get(new Integer(blockId))).getHarvestType() == HarvestType.TreeLeaf) {
                    return bp;
                }
                if (!this._treeManager.getIsLeafPass() && ((IFactoryHarvestable)harvestables.get(new Integer(blockId))).getHarvestType() == HarvestType.Tree) {
                    return bp;
                }
                if (!this._treeManager.getIsLeafPass() && ((IFactoryHarvestable)harvestables.get(new Integer(blockId))).getHarvestType() == HarvestType.TreeLeaf) {
                    this._treeManager.reset();
                    continue;
                }
            }
            this._treeManager.moveNext();
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this._tank;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        bq list = new bq();
        for (Map.Entry setting : this._settings.entrySet()) {
            list.a((String)setting.getKey(), (byte)((Boolean)setting.getValue() != false ? 1 : 0));
        }
        nbttagcompound.a("harvesterSettings", (cd)list);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        bq list = (bq)nbttagcompound.a("harvesterSettings");
        if (list != null) {
            for (String s2 : this._settings.keySet()) {
                byte b = list.c(s2);
                if (b != 1) continue;
                this._settings.put(s2, true);
            }
        }
    }

    @Override
    public String b() {
        return "Harvester";
    }

    public int k_() {
        return 1;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 0;
    }
}

