/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;

public class TileEntityFertilizer
extends TileEntityFactoryPowered
implements ISidedInventory {
    private static Map fertilizers = new HashMap();
    private static Map fertilizables = new HashMap();
    private Random _rand = new Random();
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);

    public static void registerFertilizable(IFactoryFertilizable fertilizable) {
        fertilizables.put(fertilizable.getFertilizableBlockId(), fertilizable);
    }

    public static void registerFertilizer(IFactoryFertilizer fertilizer) {
        Integer i = new Integer(fertilizer.getFertilizerId());
        if (!fertilizers.containsKey(i)) {
            fertilizers.put(i, fertilizer);
        }
    }

    public TileEntityFertilizer() {
        super(960);
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[9]);
    }

    @Override
    public String getGuiBackground() {
        return "fertilizer.png";
    }

    @Override
    public boolean activateMachine() {
        BlockPosition bp = this._areaManager.getNextBlock();
        int targetId = this.k.a(bp.x, bp.y, bp.z);
        if (!fertilizables.containsKey(new Integer(targetId))) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        for (int stackIndex = 0; stackIndex < this.k_(); ++stackIndex) {
            ur fertStack = this.a(stackIndex);
            if (fertStack == null || !fertilizers.containsKey(new Integer(fertStack.c))) continue;
            IFactoryFertilizer fertilizer = (IFactoryFertilizer)fertilizers.get(new Integer(fertStack.c));
            IFactoryFertilizable fertilizable = (IFactoryFertilizable)fertilizables.get(new Integer(targetId));
            if (fertilizer.getFertilizerMeta() != fertStack.j() || !fertilizable.canFertilizeBlock(this.k, bp.x, bp.y, bp.z, fertilizer.getFertilizerType()) || !fertilizable.fertilize(this.k, this._rand, bp.x, bp.y, bp.z, fertilizer.getFertilizerType())) continue;
            fertilizer.consume(fertStack);
            if (fertStack.a <= 0) {
                this.a(stackIndex, null);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public String b() {
        return "Fertilizer";
    }

    public int k_() {
        return 10;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 20;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 9;
    }
}

