/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.xycraft;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.modhelpers.xycraft.FertilizableCorn;
import powercrystals.minefactoryreloaded.modhelpers.xycraft.FertilizableHenequen;
import powercrystals.minefactoryreloaded.modhelpers.xycraft.HarvestableHenequen;
import powercrystals.minefactoryreloaded.modhelpers.xycraft.HarvestableXycraftCorn;

@Mod(modid="MFReloaded|CompatXyCraft", name="MFR Compat: XyCraft", version="1.4.6R2.3.2", dependencies="after:MFReloaded;after:XyCraftWorld")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Xycraft {
    @Mod.Init
    public static void load(FMLInitializationEvent e) {
        if (!Loader.isModLoaded((String)"XyCraftWorld")) {
            FMLLog.warning((String)"XyCraft missing - MFR Xycraft Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> blockClass = Class.forName("soaryn.xycraft.world.XyCraftWorldBlocks");
            int CornCropsID = ((amq)blockClass.getField((String)"corn").get(null)).cm;
            int HenequenCropsID = ((amq)blockClass.getField((String)"henequen").get(null)).cm;
            Class<?> itemClass = Class.forName("soaryn.xycraft.world.XyCraftWorldItems");
            int CornCropSeedId = ((up)itemClass.getField((String)"kernel").get(null)).cj;
            int HenequenCropSeedId = ((up)itemClass.getField((String)"henequenSeeds").get(null)).cj;
            FarmingRegistry.registerHarvestable(new HarvestableXycraftCorn(CornCropsID));
            FarmingRegistry.registerHarvestable(new HarvestableHenequen(HenequenCropsID));
            FarmingRegistry.registerPlantable(new PlantableCropPlant(CornCropSeedId, CornCropsID));
            FarmingRegistry.registerPlantable(new PlantableCropPlant(HenequenCropSeedId, HenequenCropsID));
            FarmingRegistry.registerFertilizable(new FertilizableCorn(CornCropsID));
            FarmingRegistry.registerFertilizable(new FertilizableHenequen(HenequenCropsID));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

