/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.rp2;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.rp2.FertilizableRedPowerFlax;
import powercrystals.minefactoryreloaded.modhelpers.rp2.FertilizableRedPowerRubberTree;
import powercrystals.minefactoryreloaded.modhelpers.rp2.HarvestableRedPowerFlax;
import powercrystals.minefactoryreloaded.modhelpers.rp2.HarvestableRedPowerPlant;

@Mod(modid="MFReloaded|CompatRP2", name="MFR Compat: RP2", version="1.4.6R2.3.2", dependencies="after:MFReloaded;after:RedPowerWorld")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class RP2 {
    @Mod.Init
    public static void load(FMLInitializationEvent e) {
        if (!Loader.isModLoaded((String)"RedPowerWorld")) {
            FMLLog.warning((String)"RedPowerWorld missing - MFR RedPower2 Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> modClass = Class.forName("com.eloraam.redpower.RedPowerWorld");
            int blockIdLeaves = ((amq)modClass.getField((String)"blockLeaves").get(null)).cm;
            int blockIdLogs = ((amq)modClass.getField((String)"blockLogs").get(null)).cm;
            int blockIdPlants = ((amq)modClass.getField((String)"blockPlants").get(null)).cm;
            int blockIdCrops = ((amq)modClass.getField((String)"blockCrops").get(null)).cm;
            int itemCropSeedId = ((up)modClass.getField((String)"itemSeeds").get(null)).cj;
            Method fertilizeMethod = Class.forName("com.eloraam.redpower.world.BlockCustomFlower").getMethod("growTree", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            FarmingRegistry.registerHarvestable(new HarvestableTreeLeaves(blockIdLeaves));
            FarmingRegistry.registerHarvestable(new HarvestableStandard(blockIdLogs, HarvestType.Tree));
            FarmingRegistry.registerHarvestable(new HarvestableRedPowerPlant(blockIdPlants));
            FarmingRegistry.registerHarvestable(new HarvestableRedPowerFlax(blockIdCrops));
            FarmingRegistry.registerPlantable(new PlantableStandard(blockIdPlants, blockIdPlants));
            FarmingRegistry.registerPlantable(new PlantableCropPlant(itemCropSeedId, blockIdCrops));
            FarmingRegistry.registerFertilizable(new FertilizableRedPowerFlax(blockIdCrops));
            FarmingRegistry.registerFertilizable(new FertilizableRedPowerRubberTree(blockIdPlants, fertilizeMethod));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

