/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.ic2;

import ic2.api.CropCard;
import ic2.api.TECrop;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

public class HarvestableIC2Crop
implements IFactoryHarvestable {
    private int _blockId;
    private Method _getCropMethod;
    private Field _dirtyField;

    public HarvestableIC2Crop(int blockId) throws NoSuchMethodException, SecurityException, ClassNotFoundException, NoSuchFieldException {
        this._blockId = blockId;
        this._getCropMethod = Class.forName("ic2.core.block.TileEntityCrop").getMethod("crop", new Class[0]);
        this._dirtyField = Class.forName("ic2.core.block.TileEntityCrop").getField("dirty");
    }

    @Override
    public int getSourceId() {
        return this._blockId;
    }

    @Override
    public HarvestType getHarvestType() {
        return HarvestType.Normal;
    }

    @Override
    public boolean breakBlock() {
        return false;
    }

    @Override
    public boolean canBeHarvested(yc world, Map harvesterSettings, int x, int y, int z) {
        any te = world.q(x, y, z);
        if (te == null || !(te instanceof TECrop)) {
            return false;
        }
        TECrop tec = (TECrop)te;
        try {
            CropCard crop = (CropCard)this._getCropMethod.invoke((Object)tec, new Object[0]);
            if (tec.id < 0 || !crop.canBeHarvested(tec)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public List getDrops(yc world, Random rand, Map harvesterSettings, int x, int y, int z) {
        ArrayList<ur> drops = new ArrayList<ur>();
        TECrop tec = (TECrop)world.q(x, y, z);
        try {
            CropCard crop = (CropCard)this._getCropMethod.invoke((Object)tec, new Object[0]);
            float chance = crop.dropGainChance();
            for (int i = 0; i < tec.statGain; ++i) {
                chance *= 1.03f;
            }
            chance -= rand.nextFloat();
            int numDrops = 0;
            while (chance > 0.0f) {
                ++numDrops;
                chance -= rand.nextFloat();
            }
            ur[] cropDrops = new ur[numDrops];
            for (int i = 0; i < numDrops; ++i) {
                cropDrops[i] = crop.getGain(tec);
                if (cropDrops[i] == null || rand.nextInt(100) > tec.statGain) continue;
                ++cropDrops[i].a;
            }
            tec.size = crop.getSizeAfterHarvest(tec);
            this._dirtyField.setBoolean((Object)tec, true);
            if (cropDrops != null) {
                for (ur s2 : cropDrops) {
                    drops.add(s2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return drops;
    }

    @Override
    public void preHarvest(yc world, int x, int y, int z) {
    }

    @Override
    public void postHarvest(yc world, int x, int y, int z) {
    }
}

