/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.extrabiomes;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.extrabiomes.FertilizableExtraBiomesTree;

@Mod(modid="MFReloaded|CompatExtraBiomes", name="MFR Compat: ExtraBiomes", version="1.4.6R2.3.2", dependencies="after:MFReloaded;after:ExtrabiomesXL")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class ExtraBiomes {
    private static Map _harvestRegistries;

    @Mod.Init
    public static void load(FMLInitializationEvent ev) {
        if (!Loader.isModLoaded((String)"ExtrabiomesXL")) {
            FMLLog.warning((String)"ExtraBiomesXL missing - MFR ExtraBiomesXL Compat not loading", (Object[])new Object[0]);
            return;
        }
        _harvestRegistries = new HashMap();
        _harvestRegistries.put("CATTAIL", HarvestType.Normal);
        _harvestRegistries.put("FLOWER", HarvestType.Normal);
        _harvestRegistries.put("GRASS", HarvestType.Normal);
        _harvestRegistries.put("LEAFPILE", HarvestType.Normal);
        _harvestRegistries.put("CUSTOMLOG", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG0", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG1", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG2", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG3", HarvestType.Tree);
        try {
            Integer blockID;
            Object o;
            Class<?> xbbs = Class.forName("extrabiomes.lib.BlockSettings");
            for (String s2 : new String[]{"AUTUMNLEAVES", "GREENLEAVES"}) {
                o = xbbs.getField(s2).get(null);
                blockID = (Integer)xbbs.getMethod("getID", new Class[0]).invoke(o, new Object[0]);
                FarmingRegistry.registerHarvestable(new HarvestableTreeLeaves(blockID));
            }
            for (Map.Entry e : _harvestRegistries.entrySet()) {
                Object o2 = xbbs.getField((String)e.getKey()).get(null);
                Integer blockID2 = (Integer)xbbs.getMethod("getID", new Class[0]).invoke(o2, new Object[0]);
                FarmingRegistry.registerHarvestable(new HarvestableStandard(blockID2, (HarvestType)((Object)e.getValue())));
            }
            for (String s2 : new String[]{"SAPLING", "CATTAIL"}) {
                o = xbbs.getField(s2).get(null);
                blockID = (Integer)xbbs.getMethod("getID", new Class[0]).invoke(o, new Object[0]);
                FarmingRegistry.registerPlantable(new PlantableStandard(blockID, blockID));
            }
            Class<?> xbs = Class.forName("extrabiomes.blocks.BlockCustomSapling");
            Method fert = xbs.getMethod("growTree", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Random.class);
            Object o3 = xbbs.getField("SAPLING").get(null);
            int saplingBlockID = (Integer)xbbs.getMethod("getID", new Class[0]).invoke(o3, new Object[0]);
            FarmingRegistry.registerFertilizable(new FertilizableExtraBiomesTree(saplingBlockID, fert));
            FarmingRegistry.registerSludgeDrop(5, new ur(((Integer)xbbs.getMethod("getID", new Class[0]).invoke(xbbs.getField("QUICKSAND").get(null), new Object[0])).intValue(), 1, 0));
            FarmingRegistry.registerSludgeDrop(5, new ur(((Integer)xbbs.getMethod("getID", new Class[0]).invoke(xbbs.getField("CRACKEDSAND").get(null), new Object[0])).intValue(), 1, 0));
            MFRRegistry.registerRubberTreeBiome("Autumn Woods");
            MFRRegistry.registerRubberTreeBiome("Birch Forest");
            MFRRegistry.registerRubberTreeBiome("Extreme Jungle");
            MFRRegistry.registerRubberTreeBiome("Forested Hills");
            MFRRegistry.registerRubberTreeBiome("Forested Island");
            MFRRegistry.registerRubberTreeBiome("Green Hills");
            MFRRegistry.registerRubberTreeBiome("Green Swamplands");
            MFRRegistry.registerRubberTreeBiome("Mini Jungle");
            MFRRegistry.registerRubberTreeBiome("Mountain Taiga");
            MFRRegistry.registerRubberTreeBiome("Pine Forest");
            MFRRegistry.registerRubberTreeBiome("Rainforest");
            MFRRegistry.registerRubberTreeBiome("Redwood Forest");
            MFRRegistry.registerRubberTreeBiome("Lush Redwoods");
            MFRRegistry.registerRubberTreeBiome("Snow Forest");
            MFRRegistry.registerRubberTreeBiome("Snowy Rainforest");
            MFRRegistry.registerRubberTreeBiome("Temperate Rainforest");
            MFRRegistry.registerRubberTreeBiome("Woodlands");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

