/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import java.util.EnumSet;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.core.power.PowerProviderAdvanced;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryInventory;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.implement.IVoltage;

public abstract class TileEntityFactoryPowered
extends TileEntityFactoryInventory
implements IPowerReceptor,
IEnergySink,
IVoltage {
    private static int energyPerEU = 4;
    private static int energyPerMJ = 10;
    private static int wPerEnergy = 7;
    private int _energyStored;
    private int _energyActivation;
    private int _workDone;
    private int _idleTicks;
    private IPowerProvider _powerProvider;
    private boolean _isAddedToIC2EnergyNet;
    private boolean _addToNetOnNextTick;
    private int _ueBuffer;

    protected TileEntityFactoryPowered() {
        this(100);
    }

    protected TileEntityFactoryPowered(int energyActivation) {
        this._energyActivation = energyActivation;
        this._powerProvider = new PowerProviderAdvanced();
        this._powerProvider.configure(25, 10, 10, 1, 1000);
        this.setIsActive(false);
        ElectricityConnections.registerConnector(this, EnumSet.range(ForgeDirection.DOWN, ForgeDirection.EAST));
    }

    public abstract String b();

    @Override
    public void g() {
        super.g();
        this._energyStored = Math.min(this._energyStored, this.getEnergyStoredMax());
        if (this.k.I) {
            return;
        }
        if (this._addToNetOnNextTick) {
            if (!this.k.I) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this._addToNetOnNextTick = false;
            this._isAddedToIC2EnergyNet = true;
        }
        if (this.getPowerProvider() != null) {
            this.getPowerProvider().update(this);
            int mjRequired = Math.min((this.getEnergyStoredMax() - this.getEnergyStored()) / energyPerMJ, 100);
            if (this._energyStored < this.getEnergyStoredMax() && this.getPowerProvider().useEnergy(1.0f, mjRequired, false) > 0.0f) {
                int mjGained = (int)this.getPowerProvider().useEnergy(1.0f, mjRequired, true);
                this._energyStored += mjGained * energyPerMJ;
            }
        }
        ElectricityPack powerRequested = new ElectricityPack((double)((this.getEnergyStoredMax() - this.getEnergyStored()) * wPerEnergy) / this.getVoltage(new Object[0]), this.getVoltage(new Object[0]));
        ElectricityPack powerPack = ElectricityNetwork.consumeFromMultipleSides(this, powerRequested);
        this._ueBuffer = (int)((double)this._ueBuffer + powerPack.getWatts());
        int energyFromUE = Math.min(this._ueBuffer / wPerEnergy, this.getEnergyStoredMax() - this.getEnergyStored());
        this._energyStored += energyFromUE;
        this._ueBuffer -= energyFromUE * wPerEnergy;
        this.setIsActive(this._energyStored >= this._energyActivation * 2);
        if (Util.isRedstonePowered((any)this)) {
            this.setIdleTicks(this.getIdleTicksMax());
        } else if (this._idleTicks > 0) {
            --this._idleTicks;
        } else if (this._energyStored >= this._energyActivation && this.activateMachine()) {
            this._energyStored -= this._energyActivation;
        }
    }

    public void s() {
        super.s();
        if (!this._isAddedToIC2EnergyNet) {
            this._addToNetOnNextTick = true;
        }
    }

    public void w_() {
        if (this._isAddedToIC2EnergyNet) {
            if (!this.k.I) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this._isAddedToIC2EnergyNet = false;
        }
        super.w_();
    }

    protected abstract boolean activateMachine();

    public void onBlockBroken() {
        if (this._isAddedToIC2EnergyNet) {
            this._isAddedToIC2EnergyNet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public abstract int getEnergyStoredMax();

    public void setEnergyStored(int energy) {
        this._energyStored = energy;
    }

    public int getWorkDone() {
        return this._workDone;
    }

    public abstract int getWorkMax();

    public void setWorkDone(int work) {
        this._workDone = work;
    }

    public int getIdleTicks() {
        return this._idleTicks;
    }

    public abstract int getIdleTicksMax();

    public void setIdleTicks(int ticks) {
        this._idleTicks = ticks;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energyStored", this._energyStored);
        nbttagcompound.a("workDone", this._workDone);
        nbttagcompound.a("ueBuffer", this._ueBuffer);
        this._powerProvider.writeToNBT(nbttagcompound);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this._energyStored = Math.min(nbttagcompound.e("energyStored"), this.getEnergyStoredMax());
        this._workDone = Math.min(nbttagcompound.e("workDone"), this.getWorkMax());
        this._ueBuffer = nbttagcompound.e("ueBuffer");
        this._powerProvider.readFromNBT(nbttagcompound);
        this._powerProvider.configure(25, 10, 10, 1, 1000);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this._powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this._powerProvider;
    }

    @Override
    public int powerRequest() {
        return (int)Math.max((float)this._powerProvider.getMaxEnergyStored() - this._powerProvider.getEnergyStored(), 0.0f);
    }

    @Override
    public final void doWork() {
    }

    @Override
    public int demandsEnergy() {
        return (this.getEnergyStoredMax() - this._energyStored) / energyPerEU;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        int euInjected = Math.min(this.demandsEnergy(), amount);
        this._energyStored += euInjected * energyPerEU;
        return amount - euInjected;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this._isAddedToIC2EnergyNet;
    }

    @Override
    public int getMaxSafeInput() {
        return 128;
    }

    @Override
    public double getVoltage(Object ... data) {
        return 120.0;
    }
}

