/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import buildcraft.api.transport.IPipeEntry;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import powercrystals.minefactoryreloaded.api.IToolHammer;
import powercrystals.minefactoryreloaded.core.TileEntityFactory;

public class MFRUtil {
    public static boolean isHoldingWrench(qx player) {
        if (player.bJ.g() == null) {
            return false;
        }
        up currentItem = up.e[player.bJ.g().c];
        return currentItem != null && currentItem instanceof IToolHammer;
    }

    public static void pumpLiquid(ILiquidTank tank, TileEntityFactory from) {
        if (tank != null && tank.getLiquid() != null && tank.getLiquid().amount > 0) {
            LiquidStack l = tank.getLiquid().copy();
            l.amount = Math.min(l.amount, 1000);
            for (BlockPosition adj : new BlockPosition((any)from).getAdjacent(true)) {
                any tile = from.k.q(adj.x, adj.y, adj.z);
                if (tile == null || !(tile instanceof ITankContainer)) continue;
                int filled = ((ITankContainer)tile).fill(adj.orientation.getOpposite(), l, true);
                tank.drain(filled, true);
                l.amount -= filled;
                if (l.amount > 0) continue;
                break;
            }
        }
    }

    public static void mergeStacks(ur to, ur from) {
        if (to == null || from == null) {
            return;
        }
        if (to.c != from.c || to.j() != from.j()) {
            return;
        }
        if (to.p() != null || from.p() != null) {
            return;
        }
        int amountToCopy = Math.min(to.d() - to.a, from.a);
        to.a += amountToCopy;
        from.a -= amountToCopy;
    }

    public static void dropStackDirected(TileEntityFactory from, ur s2, ForgeDirection towards) {
        BlockPosition bp = new BlockPosition(from.l, from.m, from.n);
        bp.orientation = towards;
        bp.moveForwards(1);
        any te = from.k.q(bp.x, bp.y, bp.z);
        if (te != null && te instanceof la) {
            s2.a = UtilInventory.addToInventory((la)((la)te), (ForgeDirection)towards, (ur)s2);
        } else if (te != null && te instanceof IPipeEntry && ((IPipeEntry)te).acceptItems()) {
            ((IPipeEntry)te).entityEntering(s2.l(), towards);
            s2.a = 0;
            return;
        }
        if (s2.a > 0 && !from.k.isBlockSolidOnSide(bp.x, bp.y, bp.z, towards.getOpposite())) {
            MFRUtil.dropStackOnGround(s2, BlockPosition.fromFactoryTile((IRotateableTile)from), from.k, towards);
        }
    }

    public static void dropStack(TileEntityFactory from, ur s2) {
        if (s2 == null) {
            return;
        }
        s2 = s2.l();
        if (from.k.I || s2.a <= 0) {
            return;
        }
        for (ForgeDirection forgeDirection : UtilInventory.findPipes((yc)from.k, (int)from.l, (int)from.m, (int)from.n)) {
            BlockPosition bp = new BlockPosition(from.l, from.m, from.n);
            bp.orientation = forgeDirection;
            bp.moveForwards(1);
            any te = from.k.q(bp.x, bp.y, bp.z);
            if (te == null || !(te instanceof IPipeEntry) || !((IPipeEntry)te).acceptItems()) continue;
            ((IPipeEntry)te).entityEntering(s2, forgeDirection);
            return;
        }
        if (MineFactoryReloadedCore.machinesCanDropInChests.getBoolean(true)) {
            // empty if block
        }
        for (Map.Entry entry : UtilInventory.findChests((yc)from.k, (int)from.l, (int)from.m, (int)from.n).entrySet()) {
            if (((la)entry.getValue()).b() == "Engine") continue;
            if (entry.getValue() instanceof IDeepStorageUnit) {
                IDeepStorageUnit idsu = (IDeepStorageUnit)entry.getValue();
                if (s2.p() != null || idsu.getStoredItemType() != null && (idsu.getStoredItemType().c != s2.c || idsu.getStoredItemType().j() != s2.j())) continue;
            }
            s2.a = UtilInventory.addToInventory((la)((la)entry.getValue()), (ForgeDirection)((ForgeDirection)entry.getKey()), (ur)s2);
            if (s2.a != 0) continue;
            return;
        }
        if (s2.a > 0) {
            MFRUtil.dropStackOnGround(s2, BlockPosition.fromFactoryTile((IRotateableTile)from), from.k, from.getDropDirection());
        }
    }

    private static void dropStackOnGround(ur stack, BlockPosition from, yc world, ForgeDirection towards) {
        float dropOffsetX = 0.0f;
        float dropOffsetY = 0.0f;
        float dropOffsetZ = 0.0f;
        switch (towards) {
            case UNKNOWN: 
            case UP: {
                dropOffsetX = 0.5f;
                dropOffsetY = 1.5f;
                dropOffsetZ = 0.5f;
                break;
            }
            case DOWN: {
                dropOffsetX = 0.5f;
                dropOffsetY = -0.75f;
                dropOffsetZ = 0.5f;
                break;
            }
            case NORTH: {
                dropOffsetX = 0.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = -0.5f;
                break;
            }
            case SOUTH: {
                dropOffsetX = 0.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = 1.5f;
                break;
            }
            case EAST: {
                dropOffsetX = 1.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = 0.5f;
                break;
            }
            case WEST: {
                dropOffsetX = -0.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = 0.5f;
                break;
            }
        }
        px entityitem = new px(world, (double)((float)from.x + dropOffsetX), (double)((float)from.y + dropOffsetY), (double)((float)from.z + dropOffsetZ), stack.l());
        entityitem.w = 0.0;
        if (towards != ForgeDirection.DOWN) {
            entityitem.x = 0.3;
        }
        entityitem.y = 0.0;
        entityitem.b = 20;
        world.d((lq)entityitem);
        stack.a = 0;
    }
}

