/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.core.TileEntityFactory;
import powercrystals.minefactoryreloaded.processing.ItemUpgrade;

public class HarvestAreaManager {
    private TileEntityFactory _owner;
    private int _originX;
    private int _originY;
    private int _originZ;
    private ForgeDirection _originOrientation;
    private ForgeDirection _overrideDirection = ForgeDirection.UNKNOWN;
    private Area _harvestArea;
    private int _radius;
    private int _areaUp;
    private int _areaDown;
    private List _harvestedBlocks;
    private int _currentBlock;
    private int _upgradeLevel;

    public HarvestAreaManager(TileEntityFactory owner, int harvestRadius, int harvestAreaUp, int harvestAreaDown) {
        this._radius = harvestRadius;
        this._areaUp = harvestAreaUp;
        this._areaDown = harvestAreaDown;
        this._owner = owner;
        this._originX = owner.l;
        this._originY = owner.m;
        this._originZ = owner.n;
        this._originOrientation = owner.getDirectionFacing();
    }

    public Area getHarvestArea() {
        this.checkRecalculate();
        return this._harvestArea;
    }

    public int getRadius() {
        return this._radius + this._upgradeLevel;
    }

    public BlockPosition getNextBlock() {
        this.checkRecalculate();
        BlockPosition next = (BlockPosition)this._harvestedBlocks.get(this._currentBlock);
        ++this._currentBlock;
        if (this._currentBlock >= this._harvestedBlocks.size()) {
            this._currentBlock = 0;
        }
        return next;
    }

    public void rewindBlock() {
        --this._currentBlock;
        if (this._currentBlock < 0) {
            this._currentBlock = this._harvestedBlocks.size() - 1;
        }
    }

    public void setOverrideDirection(ForgeDirection dir) {
        this._overrideDirection = dir;
    }

    public void updateUpgradeLevel(ur stack) {
        int newUpgradeLevel = 0;
        if (stack != null && stack.b() instanceof ItemUpgrade) {
            newUpgradeLevel = ((ItemUpgrade)stack.b()).getUpgradeLevel(stack);
        }
        if (newUpgradeLevel != this._upgradeLevel) {
            this._upgradeLevel = newUpgradeLevel;
            this.recalculateArea();
        }
    }

    private void checkRecalculate() {
        if (this._harvestArea == null) {
            this.recalculateArea();
            return;
        }
        if (this._overrideDirection != ForgeDirection.UNKNOWN && this._originOrientation != this._overrideDirection || this._overrideDirection == ForgeDirection.UNKNOWN && this._originOrientation != this._owner.getDirectionFacing() || this._originX != this._owner.l || this._originY != this._owner.m || this._originZ != this._owner.n) {
            this.recalculateArea();
        }
    }

    private void recalculateArea() {
        BlockPosition ourpos = BlockPosition.fromFactoryTile((IRotateableTile)this._owner);
        if (this._overrideDirection != ForgeDirection.UNKNOWN) {
            ourpos.orientation = this._overrideDirection;
        }
        this._originX = ourpos.x;
        this._originY = ourpos.y;
        this._originZ = ourpos.z;
        this._originOrientation = ourpos.orientation;
        int radius = this._radius + this._upgradeLevel;
        if (ourpos.orientation == ForgeDirection.UP || ourpos.orientation == ForgeDirection.DOWN) {
            ourpos.moveForwards(1);
        } else {
            ourpos.moveForwards(radius + 1);
        }
        this._harvestArea = new Area(ourpos, radius, this._areaDown, this._areaUp);
        this._harvestedBlocks = this._harvestArea.getPositionsBottomFirst();
        this._currentBlock = 0;
    }
}

