/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.api;

import java.lang.reflect.Method;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;

public class FarmingRegistry {
    public static void registerPlantable(IFactoryPlantable plantable) {
        try {
            Class<?> planter = Class.forName("powercrystals.minefactoryreloaded.plants.TileEntityPlanter");
            if (planter != null) {
                Method reg = planter.getMethod("registerPlantable", IFactoryPlantable.class);
                reg.invoke(planter, plantable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerHarvestable(IFactoryHarvestable harvestable) {
        try {
            Class<?> harvester = Class.forName("powercrystals.minefactoryreloaded.plants.TileEntityHarvester");
            if (harvester != null) {
                Method reg = harvester.getMethod("registerHarvestable", IFactoryHarvestable.class);
                reg.invoke(harvester, harvestable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerFertilizable(IFactoryFertilizable fertilizable) {
        try {
            Class<?> fertilizer = Class.forName("powercrystals.minefactoryreloaded.plants.TileEntityFertilizer");
            if (fertilizer != null) {
                Method reg = fertilizer.getMethod("registerFertilizable", IFactoryFertilizable.class);
                reg.invoke(fertilizer, fertilizable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerFertilizer(IFactoryFertilizer fertilizer) {
        try {
            Class<?> fertilizerTE = Class.forName("powercrystals.minefactoryreloaded.plants.TileEntityFertilizer");
            if (fertilizerTE != null) {
                Method reg = fertilizerTE.getMethod("registerFertilizer", IFactoryFertilizer.class);
                reg.invoke(fertilizerTE, fertilizer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerRanchable(IFactoryRanchable ranchable) {
        try {
            Class<?> rancher = Class.forName("powercrystals.minefactoryreloaded.animals.TileEntityRancher");
            if (rancher != null) {
                Method reg = rancher.getMethod("registerRanchable", IFactoryRanchable.class);
                reg.invoke(rancher, ranchable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerGrindable(IFactoryGrindable grindable) {
        try {
            Class<?> grinder = Class.forName("powercrystals.minefactoryreloaded.animals.TileEntityGrinder");
            if (grinder != null) {
                Method reg = grinder.getMethod("registerGrindable", IFactoryGrindable.class);
                reg.invoke(grinder, grindable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerSludgeDrop(int weight, ur drop) {
        try {
            Class<?> boiler = Class.forName("powercrystals.minefactoryreloaded.processing.TileEntitySludgeBoiler");
            if (boiler != null) {
                Method reg = boiler.getMethod("registerSludgeDrop", Integer.TYPE, ur.class);
                reg.invoke(boiler, weight, drop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerSafariNetHandler(ISafariNetHandler handler) {
        try {
            Class<?> registry = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry");
            if (registry != null) {
                Method reg = registry.getMethod("registerSafariNetHandler", ISafariNetHandler.class);
                reg.invoke(registry, handler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerMobEggHandler(IMobEggHandler handler) {
        try {
            Class<?> registry = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry");
            if (registry != null) {
                Method reg = registry.getMethod("registerMobEggHandler", IMobEggHandler.class);
                reg.invoke(registry, handler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerRubberTreeBiome(String biome) {
        try {
            Class<?> registry = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry");
            if (registry != null) {
                Method reg = registry.getMethod("registerRubberTreeBiome", String.class);
                reg.invoke(registry, biome);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerSafariNetBlacklist(Class blacklistedEntity) {
        try {
            Class<?> registry = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry");
            if (registry != null) {
                Method reg = registry.getMethod("registerSafariNetBlacklist", Class.class);
                reg.invoke(registry, blacklistedEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

