/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.transport.utils.ConnectionMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class FacadeMatrix
extends ConnectionMatrix {
    private String[] _textureFiles = new String[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] _textureIndex = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean dirty = false;

    public FacadeMatrix() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this._textureFiles[direction.ordinal()] = "";
        }
    }

    public String getTextureFile(ForgeDirection direction) {
        return this._textureFiles[direction.ordinal()];
    }

    public void setTextureFile(ForgeDirection direction, String filePath) {
        if (!this._textureFiles[direction.ordinal()].equals(filePath)) {
            this._textureFiles[direction.ordinal()] = filePath;
            this.dirty = true;
        }
    }

    public int getTextureIndex(ForgeDirection direction) {
        return this._textureIndex[direction.ordinal()];
    }

    public void setTextureIndex(ForgeDirection direction, int value) {
        if (this._textureIndex[direction.ordinal()] != value) {
            this._textureIndex[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    @Override
    public void clean() {
        super.clean();
        this.dirty = false;
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this._textureFiles[i] = data.readUTF();
            this._textureIndex[i] = data.readInt();
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.writeUTF(this._textureFiles[i]);
            data.writeInt(this._textureIndex[i]);
        }
    }
}

