/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.core.DefaultProps;
import buildcraft.transport.EntityData;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.PipeTransportPower;
import java.util.Iterator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TriggerPipeContents
extends Trigger
implements ITriggerPipe {
    Kind kind;

    public TriggerPipeContents(int id, Kind kind) {
        super(id);
        this.kind = kind;
    }

    @Override
    public int getIndexInTexture() {
        switch (this.kind) {
            case Empty: {
                return 48;
            }
            case ContainsItems: {
                return 49;
            }
            case ContainsLiquids: {
                return 50;
            }
            case ContainsEnergy: {
                return 51;
            }
        }
        return 48;
    }

    @Override
    public boolean hasParameter() {
        switch (this.kind) {
            case ContainsItems: 
            case ContainsLiquids: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        switch (this.kind) {
            case Empty: {
                return "Pipe Empty";
            }
            case ContainsItems: {
                return "Items Traversing";
            }
            case ContainsLiquids: {
                return "Liquid Traversing";
            }
            case ContainsEnergy: {
                return "Power Traversing";
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (pipe.transport instanceof PipeTransportItems) {
            PipeTransportItems transportItems = (PipeTransportItems)pipe.transport;
            if (this.kind == Kind.Empty) {
                return transportItems.travelingEntities.isEmpty();
            }
            if (this.kind != Kind.ContainsItems) return false;
            if (parameter != null && parameter.getItem() != null) {
                EntityData data;
                Iterator i$ = transportItems.travelingEntities.values().iterator();
                do {
                    if (!i$.hasNext()) return false;
                    data = (EntityData)i$.next();
                } while (data.item.getItemStack().c != parameter.getItem().c || data.item.getItemStack().j() != parameter.getItem().j());
                return true;
            }
            if (transportItems.travelingEntities.isEmpty()) return false;
            return true;
        }
        if (pipe.transport instanceof PipeTransportLiquids) {
            PipeTransportLiquids transportLiquids = (PipeTransportLiquids)pipe.transport;
            LiquidStack searchedLiquid = null;
            if (parameter != null && parameter.getItem() != null) {
                searchedLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)parameter.getItem());
            }
            if (this.kind == Kind.Empty) {
                ILiquidTank[] arr$ = transportLiquids.getTanks(ForgeDirection.UNKNOWN);
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    ILiquidTank b = arr$[i$];
                    if (b.getLiquid() != null && b.getLiquid().amount != 0) {
                        return false;
                    }
                    ++i$;
                }
                return true;
            }
            ILiquidTank[] arr$ = transportLiquids.getTanks(ForgeDirection.UNKNOWN);
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                ILiquidTank b = arr$[i$];
                if (b.getLiquid() != null && b.getLiquid().amount != 0) {
                    if (searchedLiquid == null) return true;
                    if (searchedLiquid.isLiquidEqual(b.getLiquid())) {
                        return true;
                    }
                }
                ++i$;
            }
            return false;
        }
        if (!(pipe.transport instanceof PipeTransportPower)) return false;
        PipeTransportPower transportPower = (PipeTransportPower)pipe.transport;
        if (this.kind == Kind.Empty) {
            short[] arr$ = transportPower.displayPower;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                short s2 = arr$[i$];
                if (s2 != 0) {
                    return false;
                }
                ++i$;
            }
            return true;
        }
        short[] arr$ = transportPower.displayPower;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            short s3 = arr$[i$];
            if (s3 != 0) {
                return true;
            }
            ++i$;
        }
        return false;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }

    public static enum Kind {
        Empty,
        ContainsItems,
        ContainsLiquids,
        ContainsEnergy;

    }
}

