/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogicObsidian;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsObsidian
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider;
    private int[] entitiesDropped = new int[32];
    private int entitiesDroppedIndex = 0;

    public PipeItemsObsidian(int itemID) {
        super(new PipeTransportItems(), new PipeLogicObsidian(), itemID);
        for (int i = 0; i < this.entitiesDropped.length; ++i) {
            this.entitiesDropped[i] = -1;
        }
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(25, 1, 64, 1, 256);
        this.powerProvider.configurePowerPerdition(1, 1);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        return 28;
    }

    @Override
    public void onEntityCollidedWithBlock(lq entity) {
        super.onEntityCollidedWithBlock(entity);
        if (entity.L) {
            return;
        }
        if (this.canSuck(entity, 0)) {
            this.pullItemIntoPipe(entity, 0);
        }
    }

    private aoe getSuckingBox(ForgeDirection orientation, int distance) {
        if (orientation == ForgeDirection.UNKNOWN) {
            return null;
        }
        Position p1 = new Position(this.xCoord, this.yCoord, this.zCoord, orientation);
        Position p2 = new Position(this.xCoord, this.yCoord, this.zCoord, orientation);
        switch (orientation) {
            case EAST: {
                p1.x += (double)distance;
                p2.x += (double)(1 + distance);
                break;
            }
            case WEST: {
                p1.x -= (double)(distance - 1);
                p2.x -= (double)distance;
                break;
            }
            case UP: 
            case DOWN: {
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case SOUTH: {
                p1.z += (double)distance;
                p2.z += (double)(distance + 1);
                break;
            }
            default: {
                p1.z -= (double)(distance - 1);
                p2.z -= (double)distance;
            }
        }
        switch (orientation) {
            case EAST: 
            case WEST: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case UP: {
                p1.y += (double)(distance + 1);
                p2.y += (double)distance;
                break;
            }
            case DOWN: {
                p1.y -= (double)(distance - 1);
                p2.y -= (double)distance;
                break;
            }
            default: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
            }
        }
        Position min = p1.min(p2);
        Position max = p1.max(p2);
        return aoe.a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    @Override
    public void doWork() {
        for (int j = 1; j < 5; ++j) {
            if (!this.trySucc(j)) continue;
            return;
        }
        this.powerProvider.useEnergy(1.0f, 1.0f, true);
    }

    private boolean trySucc(int distance) {
        aoe box = this.getSuckingBox(this.getOpenOrientation(), distance);
        if (box == null) {
            return false;
        }
        List list = this.worldObj.a(lq.class, box);
        for (int g = 0; g < list.size(); ++g) {
            ur stack;
            if (!(list.get(g) instanceof lq)) continue;
            lq entity = (lq)list.get(g);
            if (this.canSuck(entity, distance)) {
                this.pullItemIntoPipe(entity, distance);
                return true;
            }
            if (distance != 1 || !(list.get(g) instanceof py)) continue;
            py cart = (py)list.get(g);
            if (cart.L || cart.a != 1 || (stack = this.checkExtractGeneric((la)cart, true, this.getOpenOrientation())) == null || this.powerProvider.useEnergy(1.0f, 1.0f, true) != 1.0f) continue;
            px entityitem = new px(this.worldObj, cart.t, cart.u + (double)0.3f, cart.v, stack);
            entityitem.b = 10;
            this.worldObj.d((lq)entityitem);
            this.pullItemIntoPipe((lq)entityitem, 1);
            return true;
        }
        return false;
    }

    public ur checkExtractGeneric(la inventory, boolean doRemove, ForgeDirection from) {
        for (int k = 0; k < inventory.k_(); ++k) {
            ur slot;
            if (inventory.a(k) == null || inventory.a((int)k).a <= 0 || (slot = inventory.a(k)) == null || slot.a <= 0) continue;
            if (doRemove) {
                return inventory.a(k, 1);
            }
            return slot;
        }
        return null;
    }

    public void pullItemIntoPipe(lq entity, int distance) {
        if (CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            return;
        }
        ForgeDirection orientation = this.getOpenOrientation().getOpposite();
        if (orientation != ForgeDirection.UNKNOWN) {
            this.worldObj.a(entity, "random.pop", 0.2f, ((this.worldObj.t.nextFloat() - this.worldObj.t.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ur stack = null;
            double speed = 0.01f;
            if (entity instanceof px) {
                px item = (px)entity;
                ur contained = item.d();
                CoreProxy.proxy.obsidianPipePickup(this.worldObj, item, this.container);
                float energyUsed = this.powerProvider.useEnergy(distance, contained.a * distance, true);
                if (distance == 0 || energyUsed / (float)distance == (float)contained.a) {
                    stack = contained;
                    CoreProxy.proxy.removeEntity(entity);
                } else {
                    stack = contained.a((int)(energyUsed / (float)distance));
                }
                speed = Math.sqrt(item.w * item.w + item.x * item.x + item.y * item.y);
                speed = speed / 2.0 - 0.05;
                if (speed < 0.01) {
                    speed = 0.01;
                }
            } else if (entity instanceof qz) {
                this.powerProvider.useEnergy(distance, distance, true);
                stack = new ur(up.l, 1);
                CoreProxy.proxy.removeEntity(entity);
            }
            EntityPassiveItem passive = new EntityPassiveItem(this.worldObj, (double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(stack), (double)this.zCoord + 0.5, stack);
            passive.setSpeed((float)speed);
            ((PipeTransportItems)this.transport).entityEntering(passive, orientation);
        }
    }

    @Override
    public void onDropped(px item) {
        this.entitiesDroppedIndex = this.entitiesDroppedIndex + 1 >= this.entitiesDropped.length ? 0 : ++this.entitiesDroppedIndex;
        this.entitiesDropped[this.entitiesDroppedIndex] = item.k;
    }

    public boolean canSuck(lq entity, int distance) {
        if (!entity.S()) {
            return false;
        }
        if (entity instanceof px) {
            px item = (px)entity;
            if (item.d().a <= 0) {
                return false;
            }
            for (int i = 0; i < this.entitiesDropped.length; ++i) {
                if (item.k != this.entitiesDropped[i]) continue;
                return false;
            }
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        if (entity instanceof qz) {
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        return false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

