/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.network.PacketUpdate;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.network.PacketLiquidUpdate;
import buildcraft.transport.network.PacketPipeTransportContent;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.network.PipeRenderStatePacket;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeLogicDiamond;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandlerTransport
implements IPacketHandler {
    public void onPacketData(ce manager, di packet2, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet2.c));
        try {
            int packetID = data.read();
            PacketUpdate packet = new PacketUpdate();
            switch (packetID) {
                case 4: {
                    PacketPowerUpdate packetPower = new PacketPowerUpdate();
                    packetPower.readData(data);
                    this.onPacketPower((qx)player, packetPower);
                    break;
                }
                case 3: {
                    PacketLiquidUpdate packetLiquid = new PacketLiquidUpdate();
                    packetLiquid.readData(data);
                    break;
                }
                case 1: {
                    PipeRenderStatePacket descPacket = new PipeRenderStatePacket();
                    descPacket.readData(data);
                    this.onPipeDescription((qx)player, descPacket);
                    break;
                }
                case 2: {
                    PacketPipeTransportContent packetC = new PacketPipeTransportContent();
                    packetC.readData(data);
                    this.onPipeContentUpdate((qx)player, packetC);
                    break;
                }
                case 40: {
                    packet.readData(data);
                    this.onGateActions((qx)player, packet);
                    break;
                }
                case 45: {
                    packet.readData(data);
                    this.onGateTriggers((qx)player, packet);
                    break;
                }
                case 43: {
                    packet.readData(data);
                    this.onGateSelection((qx)player, packet);
                    break;
                }
                case 31: {
                    PacketSlotChange packet1 = new PacketSlotChange();
                    packet1.readData(data);
                    this.onDiamondPipeSelect((qx)player, packet1);
                    break;
                }
                case 32: {
                    PacketSlotChange packet1 = new PacketSlotChange();
                    packet1.readData(data);
                    this.onEmeraldPipeSelect((qx)player, packet1);
                    break;
                }
                case 41: {
                    PacketCoordinates packetU = new PacketCoordinates();
                    packetU.readData(data);
                    this.onGateInitRequest((qx)player, packetU);
                    break;
                }
                case 42: {
                    PacketCoordinates packetS = new PacketCoordinates();
                    packetS.readData(data);
                    this.onGateSelectionRequest((qx)((iq)player), packetS);
                    break;
                }
                case 44: {
                    PacketUpdate packet3 = new PacketUpdate();
                    packet3.readData(data);
                    this.onGateSelectionChange((qx)((iq)player), packet3);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGateActions(qx player, PacketUpdate packet) {
        rq container = player.bL;
        if (!(container instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)container).updateActions(packet);
    }

    private void onGateTriggers(qx player, PacketUpdate packet) {
        rq container = player.bL;
        if (!(container instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)container).updateTriggers(packet);
    }

    private void onGateSelection(qx player, PacketUpdate packet) {
        rq container = player.bL;
        if (!(container instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)container).setSelection(packet);
    }

    private void onPipeDescription(qx player, PipeRenderStatePacket descPacket) {
        yc world = player.p;
        if (!world.f(descPacket.posX, descPacket.posY, descPacket.posZ)) {
            return;
        }
        any entity = world.q(descPacket.posX, descPacket.posY, descPacket.posZ);
        if (entity == null) {
            return;
        }
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe tile = (TileGenericPipe)entity;
        tile.handleDescriptionPacket(descPacket);
    }

    private void onPipeContentUpdate(qx player, PacketPipeTransportContent packet) {
        yc world = player.p;
        if (!world.f(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        any entity = world.q(packet.posX, packet.posY, packet.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)pipe.pipe.transport).handleItemPacket(packet);
    }

    private void onPacketPower(qx player, PacketPowerUpdate packetPower) {
        yc world = player.p;
        if (!world.f(packetPower.posX, packetPower.posY, packetPower.posZ)) {
            return;
        }
        any entity = world.q(packetPower.posX, packetPower.posY, packetPower.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportPower)) {
            return;
        }
        ((PipeTransportPower)pipe.pipe.transport).handlePowerPacket(packetPower);
    }

    private void onGateSelectionChange(qx playerEntity, PacketUpdate packet) {
        if (!(playerEntity.bL instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)playerEntity.bL).handleSelectionChange(packet);
    }

    private void onGateSelectionRequest(qx playerEntity, PacketCoordinates packet) {
        if (!(playerEntity.bL instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)playerEntity.bL).sendSelection(playerEntity);
    }

    private void onGateInitRequest(qx playerEntity, PacketCoordinates packet) {
        if (!(playerEntity.bL instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)playerEntity.bL).handleInitRequest(playerEntity);
    }

    private TileGenericPipe getPipe(yc world, int x, int y2, int z) {
        if (!world.f(x, y2, z)) {
            return null;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }

    private void onDiamondPipeSelect(qx player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof PipeLogicDiamond)) {
            return;
        }
        ((PipeLogicDiamond)pipe.pipe.logic).a(packet.slot, packet.stack);
    }

    private void onEmeraldPipeSelect(qx player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsEmerald)) {
            return;
        }
        ((PipeItemsEmerald)pipe.pipe).a(packet.slot, packet.stack);
    }
}

