/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.BlockSignature;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.BptSlotInfo;
import buildcraft.api.blueprints.IBptContext;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.Pipe;
import java.util.LinkedList;

public class BptBlockPipe
extends BptBlock {
    public BptBlockPipe(int blockId) {
        super(blockId);
    }

    @Override
    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        int pipeId = slot.cpt.e("pipeId");
        requirements.add(new ur(pipeId, 1, 0));
        if (slot.cpt.b("wire0")) {
            requirements.add(new ur(BuildCraftTransport.redPipeWire));
        }
        if (slot.cpt.b("wire1")) {
            requirements.add(new ur(BuildCraftTransport.bluePipeWire));
        }
        if (slot.cpt.b("wire2")) {
            requirements.add(new ur(BuildCraftTransport.greenPipeWire));
        }
        if (slot.cpt.b("wire3")) {
            requirements.add(new ur(BuildCraftTransport.yellowPipeWire));
        }
        if (slot.cpt.b("gate")) {
            int gateId = slot.cpt.e("gate");
            if (slot.cpt.b("hasPulser") && slot.cpt.n("hasPulser")) {
                requirements.add(new ur(BuildCraftTransport.pipeGateAutarchic, 1, gateId - 1));
            } else {
                requirements.add(new ur(BuildCraftTransport.pipeGate, 1, gateId - 1));
            }
        }
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].addRequirements(slot, requirements);
        }
    }

    @Override
    public boolean isValid(BptSlotInfo slot, IBptContext context) {
        Pipe pipe = BlockGenericPipe.getPipe((ym)context.world(), slot.x, slot.y, slot.z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.itemID == slot.cpt.e("pipeId");
        }
        return false;
    }

    @Override
    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.e("pipeId");
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].rotateLeft(slot, context);
        }
    }

    @Override
    public void buildBlock(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.e("pipeId");
        Pipe pipe = BlockGenericPipe.createPipe(pipeId);
        for (int i = 0; i < pipe.wireSet.length; ++i) {
            if (!slot.cpt.b("wire" + i)) continue;
            pipe.wireSet[i] = true;
        }
        if (slot.cpt.b("gate")) {
            int gateId = slot.cpt.e("gate");
            GateVanilla newGate = slot.cpt.b("hasPulser") && slot.cpt.n("hasPulser") ? new GateVanilla(pipe, new ur(BuildCraftTransport.pipeGateAutarchic, 1, gateId - 1)) : new GateVanilla(pipe, new ur(BuildCraftTransport.pipeGate, 1, gateId - 1));
            pipe.gate = newGate;
            for (int i = 0; i < 8; ++i) {
                ur s2;
                if (slot.cpt.b("trigger" + i)) {
                    pipe.activatedTriggers[i] = ActionManager.triggers[slot.cpt.e("trigger" + i)];
                }
                if (slot.cpt.b("triggerParameter" + i) && (s2 = ur.a((bq)((bq)slot.cpt.a("triggerParameter" + i)))) != null) {
                    pipe.triggerParameters[i] = new TriggerParameter();
                    pipe.triggerParameters[i].set(s2);
                }
                if (!slot.cpt.b("action" + i)) continue;
                pipe.activatedActions[i] = ActionManager.actions[slot.cpt.e("action" + i)];
            }
        }
        BlockGenericPipe.placePipe(pipe, context.world(), slot.x, slot.y, slot.z, slot.blockId, slot.meta);
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].buildBlock(slot, context);
        }
    }

    @Override
    public void initializeFromWorld(BptSlotInfo bptSlot, IBptContext context, int x, int y2, int z) {
        Pipe pipe = BlockGenericPipe.getPipe((ym)context.world(), x, y2, z);
        if (BlockGenericPipe.isValid(pipe)) {
            int i;
            bptSlot.cpt.a("pipeId", pipe.itemID);
            for (i = 0; i < pipe.wireSet.length; ++i) {
                if (!pipe.wireSet[i]) continue;
                bptSlot.cpt.a("wire" + i, 1);
            }
            if (pipe.hasGate()) {
                bptSlot.cpt.a("gate", pipe.gate.kind.ordinal());
                if (pipe.gate instanceof GateVanilla) {
                    bptSlot.cpt.a("hasPulser", ((GateVanilla)pipe.gate).hasPulser());
                }
                for (i = 0; i < 8; ++i) {
                    if (pipe.activatedTriggers[i] != null) {
                        bptSlot.cpt.a("trigger" + i, pipe.activatedTriggers[i].getId());
                    }
                    if (pipe.triggerParameters[i] != null) {
                        bq subCpt = new bq();
                        pipe.triggerParameters[i].getItemStack().b(subCpt);
                        bptSlot.cpt.a("triggerParameter" + i, (cd)subCpt);
                    }
                    if (pipe.activatedActions[i] == null) continue;
                    bptSlot.cpt.a("action" + i, pipe.activatedActions[i].getId());
                }
            }
            if (BuildCraftCore.itemBptProps[pipe.itemID] != null) {
                BuildCraftCore.itemBptProps[pipe.itemID].initializeFromWorld(bptSlot, context, x, y2, z);
            }
        }
    }

    @Override
    public void postProcessing(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.e("pipeId");
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].postProcessing(slot, context);
        }
    }

    @Override
    public BlockSignature getSignature(amq block) {
        BlockSignature sig = super.getSignature(block);
        sig.mod = "BuildCraftTransport";
        sig.modVersion = "3.4.3";
        return sig;
    }
}

