/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.network.TilePacketWrapper;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.ILaserTarget;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class TileAssemblyTable
extends any
implements IMachine,
la,
IPipeConnection,
ILaserTarget {
    ur[] items = new ur[12];
    LinkedList plannedOutput = new LinkedList();
    public AssemblyRecipe currentRecipe;
    private float currentRequiredEnergy = 0.0f;
    private float energyStored = 0.0f;
    private float[] recentEnergy = new float[20];
    private int tick = 0;
    private int recentEnergyAverage;
    public static TilePacketWrapper selectionMessageWrapper = new TilePacketWrapper(SelectionMessage.class);

    public LinkedList getPotentialOutputs() {
        LinkedList<AssemblyRecipe> result = new LinkedList<AssemblyRecipe>();
        for (AssemblyRecipe recipe : AssemblyRecipe.assemblyRecipes) {
            if (!recipe.canBeDone(this.items)) continue;
            result.add(recipe);
        }
        return result;
    }

    @Override
    public void receiveLaserEnergy(float energy) {
        this.energyStored += energy;
        int n = this.tick;
        this.recentEnergy[n] = this.recentEnergy[n] + energy;
    }

    public void g() {
        ++this.tick;
        this.tick %= this.recentEnergy.length;
        this.recentEnergy[this.tick] = 0.0f;
        if (this.currentRecipe == null) {
            return;
        }
        if (!this.currentRecipe.canBeDone(this.items)) {
            this.setNextCurrentRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.energyStored >= this.currentRecipe.energy) {
            this.energyStored = 0.0f;
            if (this.currentRecipe.canBeDone(this.items)) {
                block0: for (ur in : this.currentRecipe.input) {
                    if (in == null) continue;
                    int found = 0;
                    for (int i = 0; i < this.items.length; ++i) {
                        if (this.items[i] == null || !this.items[i].a(in)) continue;
                        int supply = this.items[i].a;
                        int toBeFound = in.a - found;
                        found = supply >= toBeFound ? (found += this.a((int)i, (int)toBeFound).a) : (found += this.a((int)i, (int)supply).a);
                        if (found >= in.a) continue block0;
                    }
                }
                ur remaining = this.currentRecipe.output.l();
                ur added = Utils.addToRandomInventory(remaining, this.k, this.l, this.m, this.n, ForgeDirection.UNKNOWN);
                remaining.a -= added.a;
                if (remaining.a > 0) {
                    Utils.addToRandomPipeEntry(this, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining.a > 0) {
                    px entityitem = new px(this.k, (double)this.l + 0.5, (double)this.m + 0.7, (double)this.n + 0.5, this.currentRecipe.output.l());
                    this.k.d((lq)entityitem);
                }
                this.setNextCurrentRecipe();
            }
        }
    }

    public float getCompletionRatio(float ratio) {
        if (this.currentRecipe == null) {
            return 0.0f;
        }
        if (this.energyStored >= this.currentRecipe.energy) {
            return ratio;
        }
        return this.energyStored / this.currentRecipe.energy * ratio;
    }

    public int k_() {
        return this.items.length;
    }

    public ur a(int i) {
        return this.items[i];
    }

    public ur a(int i, int j) {
        ur stack = this.items[i].a(j);
        if (this.items[i].a == 0) {
            this.items[i] = null;
        }
        return stack;
    }

    public void a(int i, ur itemstack) {
        this.items[i] = itemstack;
        if (this.currentRecipe == null) {
            this.setNextCurrentRecipe();
        }
    }

    public ur a_(int slot) {
        if (this.items[slot] == null) {
            return null;
        }
        ur stackToTake = this.items[slot];
        this.items[slot] = null;
        return stackToTake;
    }

    public String b() {
        return "Assembly Table";
    }

    public int c() {
        return 64;
    }

    public boolean a_(qx entityplayer) {
        return this.k.q(this.l, this.m, this.n) == this;
    }

    public void l_() {
    }

    public void f() {
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "items", this.items);
        this.energyStored = nbttagcompound.g("energyStored");
        by list = nbttagcompound.m("planned");
        for (int i = 0; i < list.c(); ++i) {
            bq cpt = (bq)list.b(i);
            ur stack = ur.a((bq)cpt);
            for (AssemblyRecipe r : AssemblyRecipe.assemblyRecipes) {
                if (r.output.c != stack.c || r.output.j() != stack.j()) continue;
                this.plannedOutput.add(r);
            }
        }
        if (nbttagcompound.b("recipe")) {
            ur stack = ur.a((bq)nbttagcompound.l("recipe"));
            for (AssemblyRecipe r : this.plannedOutput) {
                if (r.output.c != stack.c || r.output.j() != stack.j()) continue;
                this.setCurrentRecipe(r);
                break;
            }
        }
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "items", this.items);
        nbttagcompound.a("energyStored", this.energyStored);
        by list = new by();
        for (AssemblyRecipe recipe : this.plannedOutput) {
            bq cpt = new bq();
            recipe.output.b(cpt);
            list.a((cd)cpt);
        }
        nbttagcompound.a("planned", (cd)list);
        if (this.currentRecipe != null) {
            bq recipe = new bq();
            this.currentRecipe.output.b(recipe);
            nbttagcompound.a("recipe", (cd)recipe);
        }
    }

    public void cleanPlannedOutput() {
        this.plannedOutput.clear();
    }

    public boolean isPlanned(AssemblyRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        for (AssemblyRecipe r : this.plannedOutput) {
            if (r != recipe) continue;
            return true;
        }
        return false;
    }

    public boolean isAssembling(AssemblyRecipe recipe) {
        return recipe != null && recipe == this.currentRecipe;
    }

    private void setCurrentRecipe(AssemblyRecipe recipe) {
        this.currentRecipe = recipe;
        this.currentRequiredEnergy = recipe != null ? recipe.energy : 0.0f;
    }

    public void planOutput(AssemblyRecipe recipe) {
        if (recipe != null && !this.isPlanned(recipe)) {
            this.plannedOutput.add(recipe);
            if (!this.isAssembling(this.currentRecipe) || !this.isPlanned(this.currentRecipe)) {
                this.setCurrentRecipe(recipe);
            }
        }
    }

    public void cancelPlanOutput(AssemblyRecipe recipe) {
        if (this.isAssembling(recipe)) {
            this.setCurrentRecipe(null);
        }
        this.plannedOutput.remove(recipe);
        if (this.plannedOutput.size() != 0) {
            this.setCurrentRecipe((AssemblyRecipe)this.plannedOutput.getFirst());
        }
    }

    public void setNextCurrentRecipe() {
        boolean takeNext = false;
        for (AssemblyRecipe recipe : this.plannedOutput) {
            if (recipe == this.currentRecipe) {
                takeNext = true;
                continue;
            }
            if (!takeNext || !recipe.canBeDone(this.items)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        for (AssemblyRecipe recipe : this.plannedOutput) {
            if (!recipe.canBeDone(this.items)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        this.setCurrentRecipe(null);
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    public void handleSelectionMessage(SelectionMessage message) {
        for (AssemblyRecipe recipe : AssemblyRecipe.assemblyRecipes) {
            if (recipe.output.c != message.itemID || recipe.output.j() != message.itemDmg) continue;
            if (message.select) {
                this.planOutput(recipe);
                break;
            }
            this.cancelPlanOutput(recipe);
            break;
        }
    }

    public void sendSelectionTo(qx player) {
        for (AssemblyRecipe r : AssemblyRecipe.assemblyRecipes) {
            SelectionMessage message = new SelectionMessage();
            message.itemID = r.output.c;
            message.itemDmg = r.output.j();
            message.select = this.isPlanned(r);
            PacketUpdate packet = new PacketUpdate(22, selectionMessageWrapper.toPayload(this.l, this.m, this.n, message));
            packet.posX = this.l;
            packet.posY = this.m;
            packet.posZ = this.n;
            CoreProxy.proxy.sendToPlayers(packet.getPacket(), this.k, (int)player.t, (int)player.u, (int)player.v, DefaultProps.NETWORK_UPDATE_RANGE);
        }
    }

    public void getGUINetworkData(int i, int j) {
        int currentStored = (int)((double)this.energyStored * 100.0);
        int requiredEnergy = (int)((double)this.currentRequiredEnergy * 100.0);
        switch (i) {
            case 0: {
                requiredEnergy = requiredEnergy & 0xFFFF0000 | j & 0xFFFF;
                this.currentRequiredEnergy = (float)requiredEnergy / 100.0f;
                break;
            }
            case 1: {
                currentStored = currentStored & 0xFFFF0000 | j & 0xFFFF;
                this.energyStored = (float)currentStored / 100.0f;
                break;
            }
            case 2: {
                requiredEnergy = requiredEnergy & 0xFFFF | (j & 0xFFFF) << 16;
                this.currentRequiredEnergy = (float)requiredEnergy / 100.0f;
                break;
            }
            case 3: {
                currentStored = currentStored & 0xFFFF | (j & 0xFFFF) << 16;
                this.energyStored = (float)currentStored / 100.0f;
                break;
            }
            case 4: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF0000 | j & 0xFFFF;
                break;
            }
            case 5: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF | (j & 0xFFFF) << 16;
            }
        }
    }

    public void sendGUINetworkData(rq container, rw iCrafting) {
        int requiredEnergy = (int)((double)this.currentRequiredEnergy * 100.0);
        int currentStored = (int)((double)this.energyStored * 100.0);
        int lRecentEnergy = 0;
        for (int i = 0; i < this.recentEnergy.length; ++i) {
            lRecentEnergy += (int)((double)this.recentEnergy[i] * 100.0 / (double)(this.recentEnergy.length - 1));
        }
        iCrafting.a(container, 0, requiredEnergy & 0xFFFF);
        iCrafting.a(container, 1, currentStored & 0xFFFF);
        iCrafting.a(container, 2, requiredEnergy >>> 16 & 0xFFFF);
        iCrafting.a(container, 3, currentStored >>> 16 & 0xFFFF);
        iCrafting.a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.a(container, 5, lRecentEnergy >>> 16 & 0xFFFF);
    }

    @Override
    public boolean isActive() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    public int getRecentEnergyAverage() {
        return this.recentEnergyAverage;
    }

    public float getStoredEnergy() {
        return this.energyStored;
    }

    public float getRequiredEnergy() {
        return this.currentRequiredEnergy;
    }

    @Override
    public boolean hasCurrentWork() {
        return this.currentRecipe != null;
    }

    @Override
    public int getXCoord() {
        return this.l;
    }

    @Override
    public int getYCoord() {
        return this.m;
    }

    @Override
    public int getZCoord() {
        return this.n;
    }

    public static class SelectionMessage {
        @TileNetworkData
        public boolean select = true;
        @TileNetworkData
        public int itemID = 0;
        @TileNetworkData
        public int itemDmg = 0;
    }
}

